/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedLongProcedure;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.Scan;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestSupport;
import org.neo4j.kernel.impl.newapi.TestUtils;

public abstract class ParallelNodeCursorTransactionStateTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    private static final ToLongFunction<NodeCursor> NODE_GET = NodeCursor::nodeReference;

    @Test
    void shouldHandleEmptyDatabase() throws TransactionFailureException {
        try (KernelTransaction tx = this.beginTransaction();
             NodeCursor cursor = tx.cursors().allocateNodeCursor(PageCursorTracer.NULL);){
            Scan scan = tx.dataRead().allNodesScan();
            while (scan.reserveBatch((Cursor)cursor, 23)) {
                Assertions.assertFalse((boolean)cursor.next());
            }
        }
    }

    @Test
    void scanShouldNotSeeDeletedNode() throws Exception {
        int size = 100;
        MutableLongSet created = LongSets.mutable.empty();
        MutableLongSet deleted = LongSets.mutable.empty();
        try (final KernelTransaction tx = this.beginTransaction();){
            Write write = tx.dataWrite();
            for (int i = 0; i < size; ++i) {
                created.add(write.nodeCreate());
                deleted.add(write.nodeCreate());
            }
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            deleted.each((LongProcedure)new CheckedLongProcedure(){

                public void safeValue(long item) throws Exception {
                    tx.dataWrite().nodeDelete(item);
                }
            });
            try (NodeCursor cursor = tx.cursors().allocateNodeCursor(PageCursorTracer.NULL);){
                Scan scan = tx.dataRead().allNodesScan();
                MutableLongSet seen = LongSets.mutable.empty();
                while (scan.reserveBatch((Cursor)cursor, 17)) {
                    while (cursor.next()) {
                        long nodeId = cursor.nodeReference();
                        Assertions.assertTrue((boolean)seen.add(nodeId));
                        Assertions.assertTrue((boolean)created.remove(nodeId));
                    }
                }
                Assertions.assertTrue((boolean)created.isEmpty());
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void scanShouldSeeAddedNodes() throws Exception {
        int size = 100;
        MutableLongSet existing = this.createNodes(size);
        MutableLongSet added = LongSets.mutable.empty();
        try (KernelTransaction tx = this.beginTransaction();){
            for (int i = 0; i < size; ++i) {
                added.add(tx.dataWrite().nodeCreate());
            }
            try (NodeCursor cursor = tx.cursors().allocateNodeCursor(PageCursorTracer.NULL);){
                Scan scan = tx.dataRead().allNodesScan();
                MutableLongSet seen = LongSets.mutable.empty();
                while (scan.reserveBatch((Cursor)cursor, 17)) {
                    while (cursor.next()) {
                        long nodeId = cursor.nodeReference();
                        Assertions.assertTrue((boolean)seen.add(nodeId));
                        Assertions.assertTrue((existing.remove(nodeId) || added.remove(nodeId) ? 1 : 0) != 0);
                    }
                }
                Assertions.assertTrue((boolean)existing.isEmpty());
                Assertions.assertTrue((boolean)added.isEmpty());
            }
        }
    }

    @Test
    void shouldReserveBatchFromTxState() throws TransactionFailureException, InvalidTransactionTypeKernelException {
        try (KernelTransaction tx = this.beginTransaction();){
            for (int i = 0; i < 11; ++i) {
                tx.dataWrite().nodeCreate();
            }
            try (NodeCursor cursor = tx.cursors().allocateNodeCursor(PageCursorTracer.NULL);){
                Scan scan = tx.dataRead().allNodesScan();
                Assertions.assertTrue((boolean)scan.reserveBatch((Cursor)cursor, 5));
                Assertions.assertEquals((int)5, (int)TestUtils.count((Cursor)cursor));
                Assertions.assertTrue((boolean)scan.reserveBatch((Cursor)cursor, 4));
                Assertions.assertEquals((int)4, (int)TestUtils.count((Cursor)cursor));
                Assertions.assertTrue((boolean)scan.reserveBatch((Cursor)cursor, 6));
                Assertions.assertEquals((int)2, (int)TestUtils.count((Cursor)cursor));
                while (scan.reserveBatch((Cursor)cursor, 3)) {
                    Assertions.assertFalse((boolean)cursor.next());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldScanAllNodesFromMultipleThreads() throws InterruptedException, ExecutionException, TransactionFailureException, InvalidTransactionTypeKernelException {
        ExecutorService service = Executors.newFixedThreadPool(4);
        CursorFactory cursors = testSupport.kernelToTest().cursors();
        int size = 128;
        LongArrayList ids = new LongArrayList();
        try (KernelTransaction tx = this.beginTransaction();){
            Write write = tx.dataWrite();
            for (int i = 0; i < size; ++i) {
                ids.add(write.nodeCreate());
            }
            Read read = tx.dataRead();
            Scan scan = read.allNodesScan();
            Future<LongList> future1 = service.submit(TestUtils.singleBatchWorker(scan, () -> cursors.allocateNodeCursor(PageCursorTracer.NULL), NodeCursor::nodeReference, size / 4));
            Future<LongList> future2 = service.submit(TestUtils.singleBatchWorker(scan, () -> cursors.allocateNodeCursor(PageCursorTracer.NULL), NodeCursor::nodeReference, size / 4));
            Future<LongList> future3 = service.submit(TestUtils.singleBatchWorker(scan, () -> cursors.allocateNodeCursor(PageCursorTracer.NULL), NodeCursor::nodeReference, size / 4));
            Future<LongList> future4 = service.submit(TestUtils.singleBatchWorker(scan, () -> cursors.allocateNodeCursor(PageCursorTracer.NULL), NodeCursor::nodeReference, size / 4));
            LongList ids1 = future1.get();
            LongList ids2 = future2.get();
            LongList ids3 = future3.get();
            LongList ids4 = future4.get();
            TestUtils.assertDistinct(ids1, ids2, ids3, ids4);
            LongList concat = TestUtils.concat(ids1, ids2, ids3, ids4);
            Assertions.assertEquals((Object)ids.toSortedList(), (Object)concat.toSortedList());
            tx.rollback();
        }
        finally {
            service.shutdown();
            service.awaitTermination(1L, TimeUnit.MINUTES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldScanAllNodesFromMultipleThreadWithBigSizeHints() throws InterruptedException, ExecutionException, TransactionFailureException, InvalidTransactionTypeKernelException {
        ExecutorService service = Executors.newFixedThreadPool(4);
        CursorFactory cursors = testSupport.kernelToTest().cursors();
        int size = 128;
        LongArrayList ids = new LongArrayList();
        try (KernelTransaction tx = this.beginTransaction();){
            Write write = tx.dataWrite();
            for (int i = 0; i < size; ++i) {
                ids.add(write.nodeCreate());
            }
            Read read = tx.dataRead();
            Scan scan = read.allNodesScan();
            Supplier<NodeCursor> allocateCursor = () -> cursors.allocateNodeCursor(PageCursorTracer.NULL);
            Future<LongList> future1 = service.submit(TestUtils.singleBatchWorker(scan, allocateCursor, NODE_GET, 100));
            Future<LongList> future2 = service.submit(TestUtils.singleBatchWorker(scan, allocateCursor, NODE_GET, 100));
            Future<LongList> future3 = service.submit(TestUtils.singleBatchWorker(scan, allocateCursor, NODE_GET, 100));
            Future<LongList> future4 = service.submit(TestUtils.singleBatchWorker(scan, allocateCursor, NODE_GET, 100));
            LongList ids1 = future1.get();
            LongList ids2 = future2.get();
            LongList ids3 = future3.get();
            LongList ids4 = future4.get();
            TestUtils.assertDistinct(ids1, ids2, ids3, ids4);
            LongList concat = TestUtils.concat(ids1, ids2, ids3, ids4);
            Assertions.assertEquals((Object)ids.toSortedList(), (Object)concat.toSortedList());
        }
        finally {
            service.shutdown();
            service.awaitTermination(1L, TimeUnit.MINUTES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldScanAllNodesFromRandomlySizedWorkers() throws InterruptedException, TransactionFailureException, InvalidTransactionTypeKernelException {
        ExecutorService service = Executors.newFixedThreadPool(4);
        int size = 128;
        LongArrayList ids = new LongArrayList();
        try (KernelTransaction tx = this.beginTransaction();){
            Write write = tx.dataWrite();
            for (int i = 0; i < size; ++i) {
                ids.add(write.nodeCreate());
            }
            Read read = tx.dataRead();
            Scan scan = read.allNodesScan();
            CursorFactory cursors = testSupport.kernelToTest().cursors();
            ArrayList<Future<LongList>> futures = new ArrayList<Future<LongList>>();
            for (int i = 0; i < 10; ++i) {
                futures.add(service.submit(TestUtils.randomBatchWorker(scan, () -> cursors.allocateNodeCursor(PageCursorTracer.NULL), NODE_GET)));
            }
            List<LongList> lists = futures.stream().map(TestUtils::unsafeGet).collect(Collectors.toList());
            TestUtils.assertDistinct(lists);
            LongList concat = TestUtils.concat(lists);
            Assertions.assertEquals((Object)ids.toSortedList(), (Object)concat.toSortedList());
            tx.rollback();
        }
        finally {
            service.shutdown();
            service.awaitTermination(1L, TimeUnit.MINUTES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void parallelTxStateScanStressTest() throws InvalidTransactionTypeKernelException, TransactionFailureException, InterruptedException {
        MutableLongSet existingNodes = this.createNodes(77);
        int workers = Runtime.getRuntime().availableProcessors();
        ExecutorService threadPool = Executors.newFixedThreadPool(workers);
        CursorFactory cursors = testSupport.kernelToTest().cursors();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        try {
            for (int i = 0; i < 1000; ++i) {
                MutableLongSet allNodes = LongSets.mutable.withAll((LongIterable)existingNodes);
                try (KernelTransaction tx = this.beginTransaction();){
                    int nodeInTx = random.nextInt(100);
                    for (int j = 0; j < nodeInTx; ++j) {
                        allNodes.add(tx.dataWrite().nodeCreate());
                    }
                    Scan scan = tx.dataRead().allNodesScan();
                    ArrayList<Future<LongList>> futures = new ArrayList<Future<LongList>>(workers);
                    for (int j = 0; j < workers; ++j) {
                        futures.add(threadPool.submit(TestUtils.randomBatchWorker(scan, () -> cursors.allocateNodeCursor(PageCursorTracer.NULL), NODE_GET)));
                    }
                    List<LongList> lists = futures.stream().map(TestUtils::unsafeGet).collect(Collectors.toList());
                    TestUtils.assertDistinct(lists);
                    LongList concat = TestUtils.concat(lists);
                    Assertions.assertEquals((Object)allNodes, (Object)LongSets.immutable.withAll((LongIterable)concat), (String)String.format("nodes=%d, seen=%d, all=%d", nodeInTx, concat.size(), allNodes.size()));
                    Assertions.assertEquals((int)allNodes.size(), (int)concat.size(), (String)String.format("nodes=%d", nodeInTx));
                    tx.rollback();
                    continue;
                }
            }
        }
        finally {
            threadPool.shutdown();
            threadPool.awaitTermination(1L, TimeUnit.MINUTES);
        }
    }

    private MutableLongSet createNodes(int size) throws TransactionFailureException, InvalidTransactionTypeKernelException {
        MutableLongSet nodes = LongSets.mutable.empty();
        try (KernelTransaction tx = this.beginTransaction();){
            Write write = tx.dataWrite();
            for (int i = 0; i < size; ++i) {
                nodes.add(write.nodeCreate());
            }
            tx.commit();
        }
        return nodes;
    }
}

