/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipIndexCursor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;

@DbmsExtension
class ReadTracingIT {
    @Inject
    private GraphDatabaseAPI database;
    private final Label label = Label.label((String)"marker");
    private final String property = "property";
    private final String testPropertyValue = "abc";
    private final String indexName = "indexName";
    private final RelationshipType type = RelationshipType.withName((String)"type");

    ReadTracingIT() {
    }

    @Test
    void tracePageCacheAccessOnNodeIndexSeek() throws KernelException {
        this.createNodeConstraint();
        this.createMatchingNode();
        try (InternalTransaction transaction = (InternalTransaction)this.database.beginTx();){
            KernelTransaction kernelTransaction = transaction.kernelTransaction();
            Read dataRead = kernelTransaction.dataRead();
            IndexDescriptor indexDescriptor = kernelTransaction.schemaRead().indexGetForName("indexName");
            PageCursorTracer cursorTracer = kernelTransaction.pageCursorTracer();
            int propertyId = kernelTransaction.tokenRead().propertyKey("property");
            this.assertZeroCursor(cursorTracer);
            IndexReadSession indexSession = dataRead.indexReadSession(indexDescriptor);
            try (NodeValueIndexCursor cursor = kernelTransaction.cursors().allocateNodeValueIndexCursor(kernelTransaction.pageCursorTracer(), kernelTransaction.memoryTracker());){
                dataRead.nodeIndexSeek(indexSession, cursor, IndexQueryConstraints.unconstrained(), new IndexQuery[]{IndexQuery.stringContains((int)propertyId, (TextValue)Values.stringValue((String)"abc"))});
                this.consumeCursor((Cursor)cursor);
            }
            this.assertOneCursor(cursorTracer);
            Assertions.assertThat((long)cursorTracer.faults()).isZero();
        }
    }

    @Test
    void noPageCacheTracingAvailableOnRelationshipIndexSeek() throws KernelException {
        this.createRelationshipIndex();
        try (Transaction tx = this.database.beginTx();){
            Node source = tx.createNode(new Label[]{this.label});
            Node target = tx.createNode(new Label[]{this.label});
            Relationship relationship = source.createRelationshipTo(target, this.type);
            relationship.setProperty("property", (Object)"abc");
            tx.commit();
        }
        try (InternalTransaction transaction = (InternalTransaction)this.database.beginTx();){
            KernelTransaction kernelTransaction = transaction.kernelTransaction();
            Read dataRead = kernelTransaction.dataRead();
            IndexDescriptor indexDescriptor = kernelTransaction.schemaRead().indexGetForName("indexName");
            PageCursorTracer cursorTracer = kernelTransaction.pageCursorTracer();
            this.assertZeroCursor(cursorTracer);
            try (RelationshipIndexCursor cursor = kernelTransaction.cursors().allocateRelationshipIndexCursor(kernelTransaction.pageCursorTracer());){
                dataRead.relationshipIndexSeek(indexDescriptor, cursor, IndexQueryConstraints.unconstrained(), new IndexQuery[]{IndexQuery.fulltextSearch((String)"abc")});
                this.consumeCursor((Cursor)cursor);
            }
            this.assertZeroCursor(cursorTracer);
        }
    }

    @Test
    void tracePageCacheAccessOnNodeIndexScan() throws KernelException {
        this.createNodeConstraint();
        this.createMatchingNode();
        try (InternalTransaction transaction = (InternalTransaction)this.database.beginTx();){
            KernelTransaction kernelTransaction = transaction.kernelTransaction();
            Read dataRead = kernelTransaction.dataRead();
            IndexDescriptor indexDescriptor = kernelTransaction.schemaRead().indexGetForName("indexName");
            PageCursorTracer cursorTracer = kernelTransaction.pageCursorTracer();
            this.assertZeroCursor(cursorTracer);
            IndexReadSession indexSession = dataRead.indexReadSession(indexDescriptor);
            try (NodeValueIndexCursor cursor = kernelTransaction.cursors().allocateNodeValueIndexCursor(kernelTransaction.pageCursorTracer(), kernelTransaction.memoryTracker());){
                dataRead.nodeIndexScan(indexSession, cursor, IndexQueryConstraints.unconstrained());
                this.consumeCursor((Cursor)cursor);
            }
            this.assertOneCursor(cursorTracer);
            Assertions.assertThat((long)cursorTracer.faults()).isZero();
        }
    }

    @Test
    void tracePageCacheAccessOnNodeWithoutTxStateCount() {
        try (InternalTransaction transaction = (InternalTransaction)this.database.beginTx();){
            KernelTransaction kernelTransaction = transaction.kernelTransaction();
            PageCursorTracer cursorTracer = kernelTransaction.pageCursorTracer();
            Read dataRead = kernelTransaction.dataRead();
            this.assertZeroCursor(cursorTracer);
            dataRead.countsForNodeWithoutTxState(0);
            this.assertOneCursor(cursorTracer);
        }
    }

    @Test
    void tracePageCacheAccessOnNodeCountByLabel() {
        try (InternalTransaction transaction = (InternalTransaction)this.database.beginTx();){
            KernelTransaction kernelTransaction = transaction.kernelTransaction();
            PageCursorTracer cursorTracer = kernelTransaction.pageCursorTracer();
            Read dataRead = kernelTransaction.dataRead();
            this.assertZeroCursor(cursorTracer);
            dataRead.countsForNode(0);
            this.assertOneCursor(cursorTracer);
        }
    }

    @Test
    void tracePageCacheAccessOnNodeCount() {
        try (InternalTransaction transaction = (InternalTransaction)this.database.beginTx();){
            KernelTransaction kernelTransaction = transaction.kernelTransaction();
            PageCursorTracer cursorTracer = kernelTransaction.pageCursorTracer();
            Read dataRead = kernelTransaction.dataRead();
            this.assertZeroCursor(cursorTracer);
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)dataRead.nodesGetCount());
            this.assertOneCursor(cursorTracer);
        }
    }

    @Test
    void tracePageCacheAccessOnRelationshipWithoutTxStateCount() {
        try (InternalTransaction transaction = (InternalTransaction)this.database.beginTx();){
            KernelTransaction kernelTransaction = transaction.kernelTransaction();
            PageCursorTracer cursorTracer = kernelTransaction.pageCursorTracer();
            Read dataRead = kernelTransaction.dataRead();
            this.assertZeroCursor(cursorTracer);
            dataRead.countsForRelationshipWithoutTxState(-1, -1, -1);
            this.assertOneCursor(cursorTracer);
        }
    }

    @Test
    void tracePageCacheAccessOnRelationshipCount() {
        try (InternalTransaction transaction = (InternalTransaction)this.database.beginTx();){
            KernelTransaction kernelTransaction = transaction.kernelTransaction();
            PageCursorTracer cursorTracer = kernelTransaction.pageCursorTracer();
            Read dataRead = kernelTransaction.dataRead();
            this.assertZeroCursor(cursorTracer);
            dataRead.countsForRelationship(-1, -1, -1);
            this.assertOneCursor(cursorTracer);
        }
    }

    private void consumeCursor(Cursor cursor) {
        while (cursor.next()) {
        }
    }

    private void createMatchingNode() {
        try (Transaction tx = this.database.beginTx();){
            Node node = tx.createNode(new Label[]{this.label});
            node.setProperty("property", (Object)"abc");
            tx.commit();
        }
    }

    private void createNodeConstraint() {
        try (Transaction tx = this.database.beginTx();){
            tx.schema().constraintFor(this.label).assertPropertyIsUnique("property").withName("indexName").create();
            tx.commit();
        }
    }

    private void createRelationshipIndex() {
        this.database.executeTransactionally("CALL db.index.fulltext.createRelationshipIndex('indexName', ['" + this.type.name() + "'], ['property'])");
        try (Transaction tx = this.database.beginTx();){
            tx.schema().awaitIndexesOnline(1L, TimeUnit.HOURS);
        }
    }

    private void assertOneCursor(PageCursorTracer cursorTracer) {
        Assertions.assertThat((long)cursorTracer.pins()).isOne();
        Assertions.assertThat((long)cursorTracer.unpins()).isOne();
        Assertions.assertThat((long)cursorTracer.hits()).isOne();
    }

    private void assertZeroCursor(PageCursorTracer cursorTracer) {
        Assertions.assertThat((long)cursorTracer.pins()).isZero();
        Assertions.assertThat((long)cursorTracer.unpins()).isZero();
        Assertions.assertThat((long)cursorTracer.hits()).isZero();
        Assertions.assertThat((long)cursorTracer.faults()).isZero();
    }
}

