/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestSupport;

public abstract class RelationshipScanCursorTestBase<G extends KernelAPIReadTestSupport>
extends KernelAPIReadTestBase<G> {
    private static List<Long> RELATIONSHIP_IDS;
    private static long none;
    private static long loop;
    private static long one;
    private static long c;
    private static long d;

    @Override
    public void createTestGraph(GraphDatabaseService graphDb) {
        Relationship deleted;
        try (Transaction tx = graphDb.beginTx();){
            Node a = tx.createNode();
            Node b = tx.createNode();
            Node c = tx.createNode();
            Node d = tx.createNode();
            Node e = tx.createNode();
            Node f = tx.createNode();
            a.createRelationshipTo(b, RelationshipType.withName((String)"CIRCLE"));
            b.createRelationshipTo(c, RelationshipType.withName((String)"CIRCLE"));
            one = c.createRelationshipTo(d, RelationshipType.withName((String)"CIRCLE")).getId();
            d.createRelationshipTo(e, RelationshipType.withName((String)"CIRCLE"));
            e.createRelationshipTo(f, RelationshipType.withName((String)"CIRCLE"));
            f.createRelationshipTo(a, RelationshipType.withName((String)"CIRCLE"));
            a.createRelationshipTo(b, RelationshipType.withName((String)"TRIANGLE"));
            a.createRelationshipTo(c, RelationshipType.withName((String)"TRIANGLE"));
            b.createRelationshipTo(c, RelationshipType.withName((String)"TRIANGLE"));
            deleted = c.createRelationshipTo(b, RelationshipType.withName((String)"TRIANGLE"));
            none = deleted.getId();
            RelationshipScanCursorTestBase.c = c.getId();
            RelationshipScanCursorTestBase.d = d.getId();
            d.createRelationshipTo(e, RelationshipType.withName((String)"TRIANGLE"));
            e.createRelationshipTo(f, RelationshipType.withName((String)"TRIANGLE"));
            f.createRelationshipTo(d, RelationshipType.withName((String)"TRIANGLE"));
            loop = a.createRelationshipTo(a, RelationshipType.withName((String)"LOOP")).getId();
            tx.commit();
        }
        RELATIONSHIP_IDS = new ArrayList<Long>();
        tx = graphDb.beginTx();
        try {
            tx.getRelationshipById(deleted.getId()).delete();
            for (Relationship relationship : tx.getAllRelationships()) {
                RELATIONSHIP_IDS.add(relationship.getId());
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldScanRelationships() {
        ArrayList<Long> ids = new ArrayList<Long>();
        try (RelationshipScanCursor relationships = this.cursors.allocateRelationshipScanCursor(PageCursorTracer.NULL);){
            this.read.allRelationshipsScan(relationships);
            while (relationships.next()) {
                ids.add(relationships.relationshipReference());
            }
        }
        Assertions.assertEquals(RELATIONSHIP_IDS, ids);
    }

    @Test
    void shouldAccessRelationshipByReference() {
        try (RelationshipScanCursor relationships = this.cursors.allocateRelationshipScanCursor(PageCursorTracer.NULL);){
            for (long id : RELATIONSHIP_IDS) {
                this.read.singleRelationship(id, relationships);
                Assertions.assertTrue((boolean)relationships.next(), (String)"should access defined relationship");
                Assertions.assertEquals((long)id, (long)relationships.relationshipReference(), (String)"should access the correct relationship");
                Assertions.assertFalse((boolean)relationships.next(), (String)"should only access a single relationship");
            }
        }
    }

    @Test
    void shouldNotAccessDeletedRelationship() {
        try (RelationshipScanCursor relationships = this.cursors.allocateRelationshipScanCursor(PageCursorTracer.NULL);){
            this.read.singleRelationship(none, relationships);
            Assertions.assertFalse((boolean)relationships.next(), (String)"should not access deleted relationship");
        }
    }

    @Test
    void shouldNotAccessNegativeReferences() {
        try (RelationshipScanCursor relationship = this.cursors.allocateRelationshipScanCursor(PageCursorTracer.NULL);){
            this.read.singleRelationship(-2L, relationship);
            Assertions.assertFalse((boolean)relationship.next(), (String)"should not access negative reference relationship");
        }
    }

    @Test
    void shouldAccessRelationshipLabels() {
        HashMap<Integer, Integer> counts = new HashMap<Integer, Integer>();
        try (RelationshipScanCursor relationships = this.cursors.allocateRelationshipScanCursor(PageCursorTracer.NULL);){
            this.read.allRelationshipsScan(relationships);
            while (relationships.next()) {
                counts.compute(relationships.type(), (k, v) -> v == null ? 1 : v + 1);
            }
        }
        Assertions.assertEquals((int)3, (int)counts.size());
        int[] values = new int[3];
        int i = 0;
        Iterator iterator = counts.values().iterator();
        while (iterator.hasNext()) {
            int value = (Integer)iterator.next();
            values[i++] = value;
        }
        Arrays.sort(values);
        Assertions.assertArrayEquals((int[])new int[]{1, 6, 6}, (int[])values);
    }

    @Test
    void shouldAccessNodes() {
        try (RelationshipScanCursor relationships = this.cursors.allocateRelationshipScanCursor(PageCursorTracer.NULL);){
            this.read.singleRelationship(one, relationships);
            Assertions.assertTrue((boolean)relationships.next());
            Assertions.assertEquals((long)c, (long)relationships.sourceNodeReference());
            Assertions.assertEquals((long)d, (long)relationships.targetNodeReference());
            Assertions.assertFalse((boolean)relationships.next());
            this.read.singleRelationship(loop, relationships);
            Assertions.assertTrue((boolean)relationships.next());
            Assertions.assertEquals((long)relationships.sourceNodeReference(), (long)relationships.targetNodeReference());
            Assertions.assertFalse((boolean)relationships.next());
        }
    }
}

