/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import java.util.function.ToLongFunction;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.junit.jupiter.api.Assertions;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.Scan;

final class TestUtils {
    private TestUtils() {
        throw new UnsupportedOperationException("do not instantiate");
    }

    static void assertDistinct(LongList ... lists) {
        TestUtils.assertDistinct(Arrays.asList(lists));
    }

    static void assertDistinct(List<LongList> lists) {
        MutableLongSet seen = LongSets.mutable.empty();
        for (LongList list : lists) {
            list.forEach((LongProcedure & Serializable)item -> Assertions.assertTrue((boolean)seen.add(item), (String)String.format("%s was seen multiple times", item)));
        }
    }

    static LongList concat(LongList ... lists) {
        return TestUtils.concat(Arrays.asList(lists));
    }

    static LongList concat(List<LongList> lists) {
        MutableLongList concat = LongLists.mutable.empty();
        lists.forEach(arg_0 -> ((MutableLongList)concat).addAll(arg_0));
        return concat;
    }

    static <T extends Cursor> Callable<LongList> singleBatchWorker(Scan<T> scan, Supplier<T> supplier, ToLongFunction<T> producer, int sizeHint) {
        return () -> {
            try (Cursor nodes = (Cursor)supplier.get();){
                LongArrayList batch = new LongArrayList();
                scan.reserveBatch(nodes, sizeHint);
                while (nodes.next()) {
                    batch.add(producer.applyAsLong(nodes));
                }
                LongArrayList longArrayList = batch;
                return longArrayList;
            }
        };
    }

    static <T extends Cursor> Callable<LongList> randomBatchWorker(Scan<T> scan, Supplier<T> supplier, ToLongFunction<T> producer) {
        return () -> {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            try (Cursor nodes = (Cursor)supplier.get();){
                int sizeHint = random.nextInt(1, 5);
                LongArrayList batch = new LongArrayList();
                while (scan.reserveBatch(nodes, sizeHint)) {
                    while (nodes.next()) {
                        batch.add(producer.applyAsLong(nodes));
                    }
                }
                LongArrayList longArrayList = batch;
                return longArrayList;
            }
        };
    }

    static <T> T unsafeGet(Future<T> future) {
        try {
            return future.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static int count(Cursor cursor) {
        int count = 0;
        while (cursor.next()) {
            ++count;
        }
        return count;
    }

    static Path createTemporaryFolder() throws IOException {
        Path createdFolder = Files.createTempFile("neo4j", "", new FileAttribute[0]);
        Files.delete(createdFolder);
        Files.createDirectory(createdFolder, new FileAttribute[0]);
        return createdFolder;
    }
}

