/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.exceptions.FrozenLocksException;
import org.neo4j.internal.kernel.api.exceptions.LocksNotFrozenException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestSupport;

abstract class TransactionTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    TransactionTestBase() {
    }

    @Test
    void shouldRollbackWhenTxIsNotSuccess() throws Exception {
        long nodeId;
        try (KernelTransaction tx = this.beginTransaction();){
            nodeId = tx.dataWrite().nodeCreate();
            int labelId = tx.tokenWrite().labelGetOrCreateForName("labello");
            tx.dataWrite().nodeAddLabel(nodeId, labelId);
        }
        this.assertNoNode(nodeId);
    }

    @Test
    void shouldRollbackWhenTxIsFailed() throws Exception {
        long nodeId;
        try (KernelTransaction tx = this.beginTransaction();){
            nodeId = tx.dataWrite().nodeCreate();
            int labelId = tx.tokenWrite().labelGetOrCreateForName("labello");
            tx.dataWrite().nodeAddLabel(nodeId, labelId);
            tx.rollback();
        }
        this.assertNoNode(nodeId);
    }

    @Test
    void shouldFreezeLockInteractions() throws Exception {
        LabelSchemaDescriptor schema;
        try (KernelTransaction tx = this.beginTransaction();){
            int label = tx.tokenWrite().labelGetOrCreateForName("Label");
            int propertyKey = tx.tokenWrite().propertyKeyGetOrCreateForName("prop");
            schema = SchemaDescriptor.forLabel((int)label, (int[])new int[]{propertyKey});
            tx.schemaWrite().indexCreate((SchemaDescriptor)schema, "my index");
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            this.assertAllowedLocks(tx, (SchemaDescriptor)schema);
            tx.freezeLocks();
            this.assertFrozenLocks(tx, (SchemaDescriptor)schema);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldThawLockInteractions() throws Exception {
        LabelSchemaDescriptor schema;
        try (KernelTransaction tx = this.beginTransaction();){
            int label = tx.tokenWrite().labelGetOrCreateForName("Label");
            int propertyKey = tx.tokenWrite().propertyKeyGetOrCreateForName("prop");
            schema = SchemaDescriptor.forLabel((int)label, (int[])new int[]{propertyKey});
            tx.schemaWrite().indexCreate((SchemaDescriptor)schema, "my index");
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            tx.freezeLocks();
            tx.thawLocks();
            this.assertAllowedLocks(tx, (SchemaDescriptor)schema);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldThrowOnThawOfNotFrozenLocks() throws Exception {
        LabelSchemaDescriptor schema;
        try (KernelTransaction tx = this.beginTransaction();){
            int label = tx.tokenWrite().labelGetOrCreateForName("Label");
            int propertyKey = tx.tokenWrite().propertyKeyGetOrCreateForName("prop");
            schema = SchemaDescriptor.forLabel((int)label, (int[])new int[]{propertyKey});
            tx.schemaWrite().indexCreate((SchemaDescriptor)schema, "my index");
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            Assertions.assertThrows(LocksNotFrozenException.class, () -> ((KernelTransaction)tx).thawLocks());
            this.assertAllowedLocks(tx, (SchemaDescriptor)schema);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldNestFreezeLocks() throws Exception {
        LabelSchemaDescriptor schema;
        try (KernelTransaction tx = this.beginTransaction();){
            int label = tx.tokenWrite().labelGetOrCreateForName("Label");
            int propertyKey = tx.tokenWrite().propertyKeyGetOrCreateForName("prop");
            schema = SchemaDescriptor.forLabel((int)label, (int[])new int[]{propertyKey});
            tx.schemaWrite().indexCreate((SchemaDescriptor)schema, "my index");
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            tx.freezeLocks();
            tx.freezeLocks();
            tx.freezeLocks();
            tx.freezeLocks();
            this.assertFrozenLocks(tx, (SchemaDescriptor)schema);
            tx.thawLocks();
            this.assertFrozenLocks(tx, (SchemaDescriptor)schema);
            tx.thawLocks();
            this.assertFrozenLocks(tx, (SchemaDescriptor)schema);
            tx.thawLocks();
            this.assertFrozenLocks(tx, (SchemaDescriptor)schema);
            tx.thawLocks();
            this.assertAllowedLocks(tx, (SchemaDescriptor)schema);
            tx.freezeLocks();
            this.assertFrozenLocks(tx, (SchemaDescriptor)schema);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldCommitOnFrozenLocks() throws Exception {
        long node;
        try (KernelTransaction tx = this.beginTransaction();){
            node = tx.dataWrite().nodeCreate();
            tx.freezeLocks();
            tx.commit();
        }
        this.assertNodeExists(node);
    }

    private void assertAllowedLocks(KernelTransaction tx, SchemaDescriptor schema) {
        tx.schemaRead().index(schema).forEachRemaining(index -> {});
    }

    private void assertFrozenLocks(KernelTransaction tx, SchemaDescriptor schema) {
        Assertions.assertThrows(FrozenLocksException.class, () -> tx.schemaRead().index(schema).forEachRemaining(index -> {}));
    }

    private void assertNoNode(long nodeId) throws TransactionFailureException {
        try (KernelTransaction tx = this.beginTransaction();
             NodeCursor cursor = tx.cursors().allocateNodeCursor(PageCursorTracer.NULL);){
            tx.dataRead().singleNode(nodeId, cursor);
            Assertions.assertFalse((boolean)cursor.next());
        }
    }

    private void assertNodeExists(long nodeId) throws TransactionFailureException {
        try (KernelTransaction tx = this.beginTransaction();
             NodeCursor cursor = tx.cursors().allocateNodeCursor(PageCursorTracer.NULL);){
            tx.dataRead().singleNode(nodeId, cursor);
            Assertions.assertTrue((boolean)cursor.next());
        }
    }
}

