/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.batchinsert.BatchInserter;
import org.neo4j.batchinsert.BatchInserters;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.EphemeralNeo4jLayoutExtension;
import org.neo4j.test.extension.Inject;

@EphemeralNeo4jLayoutExtension
class PropertyKeyTest {
    @Inject
    private EphemeralFileSystemAbstraction fs;
    @Inject
    private DatabaseLayout databaseLayout;

    PropertyKeyTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void lazyLoadWithinWriteTransaction() throws IOException {
        BatchInserter inserter = BatchInserters.inserter((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fs);
        int count = 3000;
        long nodeId = inserter.createNode(PropertyKeyTest.mapWithManyProperties(count), new Label[0]);
        inserter.shutdown();
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.databaseLayout).setFileSystem((FileSystemAbstraction)this.fs).impermanent().build();
        GraphDatabaseService db = managementService.database("neo4j");
        try (Transaction tx = db.beginTx();){
            tx.createNode();
            Node node = tx.getNodeById(nodeId);
            Assertions.assertEquals((long)count, (long)Iterables.count((Iterable)node.getPropertyKeys()));
            tx.commit();
        }
        finally {
            managementService.shutdown();
        }
    }

    private static Map<String, Object> mapWithManyProperties(int count) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (int i = 0; i < count; ++i) {
            properties.put("key:" + i, "value");
        }
        return properties;
    }
}

