/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.Iterator;
import java.util.function.Consumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension(configurationCallback="configure")
class RelationshipChainPointerChasingTest {
    private static final int THRESHOLD = 10;
    @Inject
    private GraphDatabaseService db;

    RelationshipChainPointerChasingTest() {
    }

    @ExtensionCallback
    static void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseSettings.dense_node_threshold, (Object)10);
    }

    @Test
    void shouldChaseTheLivingRelationships() throws Exception {
        Relationship[] relationships;
        Node node;
        int numberOfRelationships = 5;
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode();
            for (int i = 0; i < numberOfRelationships; ++i) {
                node.createRelationshipTo(tx.createNode(), (RelationshipType)MyRelTypes.TEST);
            }
            tx.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            relationships = (Relationship[])Iterables.asArray(Relationship.class, (Iterable)tx.getNodeById(node.getId()).getRelationships());
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            node = tx.getNodeById(node.getId());
            Iterator<Relationship> iterator = node.getRelationships().iterator();
            this.deleteRelationshipsInSeparateThread(relationships[1], relationships[2]);
            RelationshipChainPointerChasingTest.assertNext(relationships[0], iterator);
            RelationshipChainPointerChasingTest.assertNext(relationships[3], iterator);
            RelationshipChainPointerChasingTest.assertNext(relationships[4], iterator);
            Assertions.assertFalse((boolean)iterator.hasNext());
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldChaseTheLivingRelationshipGroups() throws Exception {
        Relationship relationshipInTheEnd;
        Relationship relationshipInTheMiddle;
        Node node;
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode();
            for (int i = 0; i < 10; ++i) {
                node.createRelationshipTo(tx.createNode(), (RelationshipType)MyRelTypes.TEST);
            }
            relationshipInTheMiddle = node.createRelationshipTo(tx.createNode(), (RelationshipType)MyRelTypes.TEST2);
            relationshipInTheEnd = node.createRelationshipTo(tx.createNode(), (RelationshipType)MyRelTypes.TEST_TRAVERSAL);
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            int i;
            node = tx.getNodeById(node.getId());
            relationshipInTheEnd = tx.getRelationshipById(relationshipInTheEnd.getId());
            Iterator<Relationship> relationships = node.getRelationships().iterator();
            for (i = 0; i < 5; ++i) {
                Assertions.assertTrue((boolean)((Relationship)relationships.next()).isType((RelationshipType)MyRelTypes.TEST));
            }
            this.deleteRelationshipsInSeparateThread(relationshipInTheMiddle);
            for (i = 0; i < 5; ++i) {
                Assertions.assertTrue((boolean)((Relationship)relationships.next()).isType((RelationshipType)MyRelTypes.TEST));
            }
            RelationshipChainPointerChasingTest.assertNext(relationshipInTheEnd, relationships);
            Assertions.assertFalse((boolean)relationships.hasNext());
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private static void assertNext(Relationship expected, Iterator<Relationship> iterator) {
        Assertions.assertTrue((boolean)iterator.hasNext(), (String)"Expected there to be more relationships");
        Assertions.assertEquals((Object)expected, (Object)iterator.next(), (String)"Unexpected next relationship");
    }

    private void deleteRelationshipsInSeparateThread(Relationship ... relationships) throws InterruptedException {
        this.executeTransactionInSeparateThread(tx -> {
            for (Relationship relationship : relationships) {
                tx.getRelationshipById(relationship.getId()).delete();
            }
        });
    }

    private void executeTransactionInSeparateThread(Consumer<Transaction> actionInsideTransaction) throws InterruptedException {
        Thread thread = new Thread(() -> {
            try (Transaction tx = this.db.beginTx();){
                actionInsideTransaction.accept(tx);
                tx.commit();
            }
        });
        thread.start();
        thread.join();
    }
}

