/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.util.stream.Stream;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.transaction.TransactionCountersChecker;
import org.neo4j.kernel.impl.transaction.stats.TransactionCounters;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;

class TransactionMonitorTest {
    TransactionMonitorTest() {
    }

    private static Stream<Arguments> parameters() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{"read", db -> {}, false}), Arguments.arguments((Object[])new Object[]{"write", Transaction::createNode, true}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    void shouldCountCommittedTransactions(String name, ThrowingConsumer<Transaction, Exception> txConsumer, boolean isWriteTx) throws Exception {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder().impermanent().build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        try {
            TransactionCounters counts = (TransactionCounters)db.getDependencyResolver().resolveDependency(TransactionCounters.class);
            TransactionCountersChecker checker = new TransactionCountersChecker(counts);
            try (Transaction tx = db.beginTx();){
                txConsumer.accept((Object)tx);
                tx.commit();
            }
            checker.verifyCommitted(isWriteTx, counts);
        }
        finally {
            managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    void shouldCountRolledBackTransactions(String name, ThrowingConsumer<Transaction, Exception> txConsumer, boolean isWriteTx) throws Exception {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder().impermanent().build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        try {
            TransactionCounters counts = (TransactionCounters)db.getDependencyResolver().resolveDependency(TransactionCounters.class);
            TransactionCountersChecker checker = new TransactionCountersChecker(counts);
            try (Transaction tx = db.beginTx();){
                txConsumer.accept((Object)tx);
                tx.rollback();
            }
            checker.verifyRolledBacked(isWriteTx, counts);
        }
        finally {
            managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    void shouldCountTerminatedTransactions(String name, ThrowingConsumer<Transaction, Exception> txConsumer, boolean isWriteTx) throws Exception {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder().impermanent().build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        try {
            TransactionCounters counts = (TransactionCounters)db.getDependencyResolver().resolveDependency(TransactionCounters.class);
            TransactionCountersChecker checker = new TransactionCountersChecker(counts);
            try (Transaction tx = db.beginTx();){
                txConsumer.accept((Object)tx);
                tx.terminate();
            }
            checker.verifyTerminated(isWriteTx, counts);
        }
        finally {
            managementService.shutdown();
        }
    }
}

