/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.io.IOException;
import java.nio.file.Path;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.ObjectArrayAssert;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.io.ByteUnit;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;

@DbmsExtension(configurationCallback="configure")
public class CheckpointLogPruningIT {
    @Inject
    private GraphDatabaseService database;
    @Inject
    private LogFiles logFiles;
    @Inject
    private CheckPointer checkPointer;

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseInternalSettings.checkpoint_logical_log_rotation_threshold, (Object)ByteUnit.kibiBytes((long)1L)).setConfig(GraphDatabaseInternalSettings.checkpoint_logical_log_keep_threshold, (Object)2);
    }

    @Test
    void pruneObsoleteCheckpointLogFiles() throws IOException {
        CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
        String reason = "checkpoint for rotation test";
        for (int i = 0; i < 105; ++i) {
            this.checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo(reason));
        }
        Object[] matchedFiles = checkpointFile.getDetachedCheckpointFiles();
        Assertions.assertThat((Object[])matchedFiles).hasSize(2);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])matchedFiles).areAtLeastOne(this.fineNameCondition("checkpoint.20"))).areAtLeastOne(this.fineNameCondition("checkpoint.21"));
    }

    @Test
    void doNotPruneFilesUntilConfigured() throws IOException {
        CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
        String reason = "checkpoint for rotation test";
        for (int i = 0; i < 8; ++i) {
            this.checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo(reason));
        }
        Object[] matchedFiles = checkpointFile.getDetachedCheckpointFiles();
        Assertions.assertThat((Object[])matchedFiles).hasSize(2);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])matchedFiles).areAtLeastOne(this.fineNameCondition("checkpoint.0"))).areAtLeastOne(this.fineNameCondition("checkpoint.1"));
    }

    @Test
    void pruneAsSoonAsHaveAnyEligibleFiles() throws IOException {
        CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
        String reason = "checkpoint for rotation test";
        for (int i = 0; i < 10; ++i) {
            this.checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo(reason));
        }
        Object[] matchedFiles = checkpointFile.getDetachedCheckpointFiles();
        Assertions.assertThat((Object[])matchedFiles).hasSize(2);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])matchedFiles).areAtLeastOne(this.fineNameCondition("checkpoint.1"))).areAtLeastOne(this.fineNameCondition("checkpoint.2"));
    }

    private Condition<Path> fineNameCondition(final String name) {
        return new Condition<Path>(){

            public boolean matches(Path file) {
                return name.equals(file.getFileName().toString());
            }
        };
    }
}

