/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.HashSet;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdSequence;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.recordstorage.DirectRecordAccessSet;
import org.neo4j.internal.recordstorage.RecordAccess;
import org.neo4j.internal.recordstorage.RecordAccessSet;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.internal.recordstorage.RelationshipCreator;
import org.neo4j.internal.recordstorage.RelationshipGroupGetter;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.impl.locking.NoOpClient;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.kernel.impl.transaction.state.TrackingRecordAccess;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.lock.AcquireLockTimeoutException;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceLocker;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.ResourceTypes;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension(configurationCallback="configure")
class RelationshipCreatorTest {
    private static final int DENSE_NODE_THRESHOLD = 5;
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private IdGeneratorFactory idGeneratorFactory;
    @Inject
    private RecordStorageEngine storageEngine;

    RelationshipCreatorTest() {
    }

    @ExtensionCallback
    static void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseSettings.dense_node_threshold, (Object)5);
    }

    @Test
    void shouldOnlyChangeLockedRecordsWhenUpgradingToDenseNode() {
        long nodeId = this.createNodeWithRelationships(5);
        NeoStores neoStores = this.flipToNeoStores();
        Tracker tracker = new Tracker(neoStores, this.idGeneratorFactory);
        RelationshipGroupGetter groupGetter = new RelationshipGroupGetter((IdSequence)neoStores.getRelationshipGroupStore(), PageCursorTracer.NULL);
        RelationshipCreator relationshipCreator = new RelationshipCreator(groupGetter, 5, PageCursorTracer.NULL);
        relationshipCreator.relationshipCreate(this.idGeneratorFactory.get(IdType.RELATIONSHIP).nextId(PageCursorTracer.NULL), 0, nodeId, nodeId, (RecordAccessSet)tracker, (ResourceLocker)tracker);
        Assertions.assertEquals((int)tracker.relationshipLocksAcquired.size(), (int)tracker.changedRelationships.size());
        Assertions.assertFalse((boolean)tracker.relationshipLocksAcquired.isEmpty());
    }

    private NeoStores flipToNeoStores() {
        return this.storageEngine.testAccessNeoStores();
    }

    private long createNodeWithRelationships(int count) {
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            for (int i = 0; i < count; ++i) {
                node.createRelationshipTo(tx.createNode(), (RelationshipType)MyRelTypes.TEST);
            }
            tx.commit();
            long l = node.getId();
            return l;
        }
    }

    static class Tracker
    extends NoOpClient
    implements RecordAccessSet {
        private final RecordAccessSet delegate;
        private final TrackingRecordAccess<RelationshipRecord, Void> relRecords;
        private final Set<Long> relationshipLocksAcquired = new HashSet<Long>();
        private final Set<Long> changedRelationships = new HashSet<Long>();

        Tracker(NeoStores neoStores, IdGeneratorFactory idGeneratorFactory) {
            this.delegate = new DirectRecordAccessSet(neoStores, idGeneratorFactory);
            this.relRecords = new TrackingRecordAccess(this.delegate.getRelRecords(), this);
        }

        public void acquireExclusive(LockTracer tracer, ResourceType resourceType, long ... resourceIds) throws AcquireLockTimeoutException {
            Assertions.assertEquals((Object)ResourceTypes.RELATIONSHIP, (Object)resourceType);
            for (long resourceId : resourceIds) {
                this.relationshipLocksAcquired.add(resourceId);
            }
        }

        void changingRelationship(long relId) {
            Assertions.assertTrue((boolean)this.relationshipLocksAcquired.contains(relId), (String)("Tried to change relationship " + relId + " without this transaction having it locked"));
            this.changedRelationships.add(relId);
        }

        public RecordAccess<NodeRecord, Void> getNodeRecords() {
            return this.delegate.getNodeRecords();
        }

        public RecordAccess<PropertyRecord, PrimitiveRecord> getPropertyRecords() {
            return this.delegate.getPropertyRecords();
        }

        public RecordAccess<RelationshipRecord, Void> getRelRecords() {
            return this.relRecords;
        }

        public RecordAccess<RelationshipGroupRecord, Integer> getRelGroupRecords() {
            return this.delegate.getRelGroupRecords();
        }

        public RecordAccess<SchemaRecord, SchemaRule> getSchemaRuleChanges() {
            return this.delegate.getSchemaRuleChanges();
        }

        public RecordAccess<PropertyKeyTokenRecord, Void> getPropertyKeyTokenChanges() {
            return this.delegate.getPropertyKeyTokenChanges();
        }

        public RecordAccess<LabelTokenRecord, Void> getLabelTokenChanges() {
            return this.delegate.getLabelTokenChanges();
        }

        public RecordAccess<RelationshipTypeTokenRecord, Void> getRelationshipTypeTokenChanges() {
            return this.delegate.getRelationshipTypeTokenChanges();
        }

        public boolean hasChanges() {
            return this.delegate.hasChanges();
        }

        public int changeSize() {
            return this.delegate.changeSize();
        }
    }
}

