/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import org.apache.commons.lang3.RandomStringUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.index.label.LabelScanStore;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.transaction.state.storeview.LabelViewNodeStoreScan;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.lock.LockService;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class LabelScanNodeViewTracingIT {
    @Inject
    private GraphDatabaseAPI database;
    @Inject
    private RecordStorageEngine storageEngine;
    @Inject
    private LockService lockService;
    @Inject
    private LabelScanStore labelScanStore;

    LabelScanNodeViewTracingIT() {
    }

    @Test
    void tracePageCacheAccess() throws Exception {
        int nodeCount = 1000;
        Label label = Label.label((String)"marker");
        try (Transaction tx = this.database.beginTx();){
            for (int i = 0; i < nodeCount; ++i) {
                Node node = tx.createNode(new Label[]{label});
                node.setProperty("a", (Object)RandomStringUtils.randomAscii((int)10));
            }
            tx.commit();
        }
        int labelId = this.getLabelId(label);
        DefaultPageCacheTracer cacheTracer = new DefaultPageCacheTracer();
        try (PageCursorTracer cursorTracer = cacheTracer.createPageCursorTracer("tracePageCacheAccess");){
            LabelViewNodeStoreScan scan = new LabelViewNodeStoreScan((StorageReader)this.storageEngine.newReader(), this.lockService, this.labelScanStore, element -> false, null, new int[]{labelId}, any -> false, cursorTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            scan.run();
        }
        Assertions.assertThat((long)cacheTracer.pins()).isEqualTo(3L);
        Assertions.assertThat((long)cacheTracer.unpins()).isEqualTo(3L);
        Assertions.assertThat((long)cacheTracer.hits()).isEqualTo(3L);
    }

    private int getLabelId(Label label) {
        try (Transaction tx = this.database.beginTx();){
            int n = ((InternalTransaction)tx).kernelTransaction().tokenRead().nodeLabel(label.name());
            return n;
        }
    }
}

