/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.recovery;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.rule.TestDirectory;

@RunWith(value=Parameterized.class)
public class UniquenessRecoveryTest {
    private static final boolean USE_CYPHER;
    public static final boolean EXHAUSTIVE;
    private static final int[] KILL_SIGNALS;
    private static DatabaseManagementService managementService;
    @Rule
    public final SuppressOutput muted = SuppressOutput.suppress((SuppressOutput.Suppressible[])new SuppressOutput.Suppressible[]{SuppressOutput.System.out});
    @Rule
    public final TestDirectory dir = TestDirectory.testDirectory();
    private final Configuration config;
    private static final Field PID;

    private static String param(String name) {
        return UniquenessRecoveryTest.class.getName() + "." + name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldUpholdConstraintEvenAfterRestart() throws Exception {
        Assume.assumeNotNull((Object[])new Object[]{PID});
        Path path = this.dir.absolutePath();
        System.out.println("in path: " + path);
        ProcessBuilder prototype = new ProcessBuilder("java", "-ea", "-Xmx1G", "-Djava.awt.headless=true", "-Dforce_create_constraint=" + this.config.force_create_constraint, "-D" + UniquenessRecoveryTest.param("use_cypher") + "=" + USE_CYPHER, "-cp", System.getProperty("java.class.path"), this.getClass().getName(), path.toAbsolutePath().toString());
        prototype.environment().put("JAVA_HOME", System.getProperty("java.home"));
        System.out.println("== first subprocess ==");
        Process process = prototype.start();
        if (this.awaitMessage(process, "kill me") != null) {
            throw new IllegalStateException("first process failed to execute properly");
        }
        UniquenessRecoveryTest.kill(this.config.kill_signal, process);
        this.awaitMessage(process, null);
        System.out.println("== second subprocess ==");
        process = prototype.start();
        Integer exitCode = this.awaitMessage(process, "kill me");
        if (exitCode == null) {
            UniquenessRecoveryTest.kill(this.config.kill_signal, process);
            this.awaitMessage(process, null);
        } else if (exitCode != 0) {
            System.out.println("! second process did not exit in an expected manner");
        }
        GraphDatabaseService db = UniquenessRecoveryTest.graphdb(path);
        try {
            UniquenessRecoveryTest.shouldHaveUniquenessConstraintForNamePropertyOnPersonLabel(db);
            UniquenessRecoveryTest.nodesWithPersonLabelHaveUniqueName(db);
        }
        finally {
            managementService.shutdown();
        }
    }

    public static void main(String ... args) throws Exception {
        System.out.println("hello world");
        Path path = Path.of(args[0], new String[0]).toAbsolutePath();
        boolean createConstraint = Boolean.getBoolean("force_create_constraint") || !Files.isRegularFile(path.resolve("neostore"), new LinkOption[0]);
        GraphDatabaseService db = UniquenessRecoveryTest.graphdb(path);
        System.out.println("database started");
        System.out.println("createConstraint = " + createConstraint);
        if (createConstraint) {
            try {
                System.out.println("> creating constraint");
                UniquenessRecoveryTest.createConstraint(db);
                System.out.println("< created constraint");
            }
            catch (Exception e) {
                System.out.println("!! failed to create constraint");
                e.printStackTrace(System.out);
                if (e instanceof ConstraintViolationException) {
                    System.out.println("... that is ok, since it means that constraint already exists ...");
                }
                System.exit(1);
            }
        }
        try {
            System.out.println("> adding node");
            UniquenessRecoveryTest.addNode(db);
            System.out.println("< added node");
        }
        catch (ConstraintViolationException e) {
            System.out.println("!! failed to add node");
            e.printStackTrace(System.out);
            System.out.println("... this is probably what we want :) -- [but let's let the parent process verify]");
            managementService.shutdown();
            System.exit(0);
        }
        catch (Exception e) {
            System.out.println("!! failed to add node");
            e.printStackTrace(System.out);
            System.exit(2);
        }
        UniquenessRecoveryTest.flushPageCache(db);
        System.out.println("kill me");
        UniquenessRecoveryTest.await();
    }

    private static void shouldHaveUniquenessConstraintForNamePropertyOnPersonLabel(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            ConstraintDefinition constraint = (ConstraintDefinition)Iterables.single((Iterable)tx.schema().getConstraints());
            Assert.assertEquals((Object)ConstraintType.UNIQUENESS, (Object)constraint.getConstraintType());
            Assert.assertEquals((Object)"Person", (Object)constraint.getLabel().name());
            Assert.assertEquals((Object)"name", (Object)Iterables.single((Iterable)constraint.getPropertyKeys()));
            tx.commit();
        }
    }

    private static void nodesWithPersonLabelHaveUniqueName(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            try (ResourceIterator person = tx.findNodes(Label.label((String)"Person"));){
                HashSet<Object> names = new HashSet<Object>();
                while (person.hasNext()) {
                    Object name = ((Node)person.next()).getProperty("name", null);
                    if (name == null) continue;
                    Assert.assertTrue((String)("non-unique name: " + name), (boolean)names.add(name));
                }
            }
            tx.commit();
        }
    }

    private static void createConstraint(GraphDatabaseService db) {
        if (USE_CYPHER) {
            db.executeTransactionally("create constraint on (p:Person) assert p.name is unique");
        } else {
            try (Transaction tx = db.beginTx();){
                tx.schema().constraintFor(Label.label((String)"Person")).assertPropertyIsUnique("name").create();
                tx.commit();
            }
        }
    }

    private static void addNode(GraphDatabaseService db) {
        if (USE_CYPHER) {
            db.executeTransactionally("create (:Person {name: 'Sneaky Steve'})");
        } else {
            try (Transaction tx = db.beginTx();){
                tx.createNode(new Label[]{Label.label((String)"Person")}).setProperty("name", (Object)"Sneaky Steve");
                tx.commit();
            }
        }
    }

    private static GraphDatabaseService graphdb(Path path) {
        managementService = new TestDatabaseManagementServiceBuilder(path).build();
        return managementService.database("neo4j");
    }

    private static void flushPageCache(GraphDatabaseService db) {
        try {
            ((PageCache)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(PageCache.class)).flushAndForce();
        }
        catch (IOException e) {
            System.out.println("!! failed to force the page cache");
            e.printStackTrace(System.out);
        }
    }

    static void await() throws IOException {
        System.in.read();
    }

    @Parameterized.Parameters(name="{0}")
    public static List<Object[]> configurations() {
        ArrayList<Object[]> configurations = new ArrayList<Object[]>();
        if (EXHAUSTIVE) {
            for (int killSignal : KILL_SIGNALS) {
                configurations.add(new Configuration().force_create_constraint(true).kill_signal(killSignal).build());
                configurations.add(new Configuration().force_create_constraint(false).kill_signal(killSignal).build());
            }
        } else {
            configurations.add(new Configuration().build());
        }
        return configurations;
    }

    public UniquenessRecoveryTest(Configuration config) {
        this.config = config;
    }

    private static String pidOf(Process process) throws Exception {
        return PID.get(process).toString();
    }

    private static void kill(int signal, Process process) throws Exception {
        int exitCode = new ProcessBuilder("kill", "-" + signal, UniquenessRecoveryTest.pidOf(process)).start().waitFor();
        if (exitCode != 0) {
            throw new IllegalStateException("<kill -" + signal + "> failed, exit code: " + exitCode);
        }
    }

    private Integer awaitMessage(Process process, String message) throws IOException, InterruptedException {
        String line;
        String line2;
        BufferedReader out = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((line2 = out.readLine()) != null) {
            System.out.println(line2);
            if (message == null || !line2.contains(message)) continue;
            return null;
        }
        int exitCode = process.waitFor();
        BufferedReader err = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((line = out.readLine()) != null) {
            System.out.println(line);
        }
        while ((line = err.readLine()) != null) {
            System.err.println(line);
        }
        System.out.println("process exited with exit code: " + exitCode);
        return exitCode;
    }

    static {
        Field pid;
        USE_CYPHER = Boolean.getBoolean(UniquenessRecoveryTest.param("use_cypher"));
        EXHAUSTIVE = Boolean.getBoolean(UniquenessRecoveryTest.param("exhaustive"));
        KILL_SIGNALS = new int[]{1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14, 15, 24, 26, 27, 30, 31};
        try {
            pid = Class.forName("java.lang.UNIXProcess").getDeclaredField("pid");
            pid.setAccessible(true);
        }
        catch (Throwable ex) {
            pid = null;
        }
        PID = pid;
    }

    public static class Configuration {
        boolean force_create_constraint;
        int kill_signal = 9;

        public Configuration force_create_constraint(boolean force_create_constraint) {
            this.force_create_constraint = force_create_constraint;
            return this;
        }

        public Object[] build() {
            return new Object[]{this};
        }

        public Configuration kill_signal(int kill_signal) {
            this.kill_signal = kill_signal;
            return this;
        }

        public String toString() {
            return "Configuration{use_cypher=" + USE_CYPHER + ", force_create_constraint=" + this.force_create_constraint + ", kill_signal=" + this.kill_signal + "}";
        }
    }
}

