/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tracers;

import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.CountsDelta;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TransactionCountingStateVisitor;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
public class TransactionCountingStateVisitorTraceIT {
    @Inject
    private GraphDatabaseAPI database;
    private static final Label marker = Label.label((String)"marker");
    private static final Label label = Label.label((String)"label");
    private long sourceNodeId;
    private long relationshipId;

    @BeforeEach
    void setUp() {
        try (Transaction transaction = this.database.beginTx();){
            Node source = transaction.createNode(new Label[]{marker, label});
            this.sourceNodeId = source.getId();
            Node destination = transaction.createNode();
            Relationship relationship = source.createRelationshipTo(destination, RelationshipType.withName((String)"any"));
            this.relationshipId = relationship.getId();
            transaction.commit();
        }
    }

    @Test
    void traceDeletedRelationshipPageCacheAccess() throws KernelException {
        this.traceStateWithChanges(tx -> tx.getRelationshipById(this.relationshipId).delete());
    }

    @Test
    void traceNodeLabelChangesPageCacheAccess() throws KernelException {
        this.traceStateWithChanges(tx -> tx.getNodeById(this.sourceNodeId).removeLabel(marker));
    }

    @Test
    void traceDeletedNodePageCacheAccess() throws KernelException {
        this.traceStateWithChanges(tx -> tx.getNodeById(this.sourceNodeId).delete());
    }

    private void traceStateWithChanges(Consumer<Transaction> transactionalOperation) throws KernelException {
        try (Transaction transaction = this.database.beginTx();){
            InternalTransaction internalTransaction = (InternalTransaction)transaction;
            KernelTransactionImplementation kernelTransaction = (KernelTransactionImplementation)internalTransaction.kernelTransaction();
            PageCursorTracer cursorTracer = kernelTransaction.pageCursorTracer();
            transactionalOperation.accept(transaction);
            cursorTracer.reportEvents();
            this.assertZeroCursor(cursorTracer);
            TransactionState transactionState = kernelTransaction.txState();
            CountsDelta counts = new CountsDelta();
            try (StorageReader storageReader = kernelTransaction.newStorageReader();
                 TransactionCountingStateVisitor stateVisitor = new TransactionCountingStateVisitor(TxStateVisitor.EMPTY, storageReader, (ReadableTransactionState)transactionState, counts, cursorTracer);){
                transactionState.accept((TxStateVisitor)stateVisitor);
            }
            this.assertTwoCursor(cursorTracer);
        }
    }

    private void assertTwoCursor(PageCursorTracer cursorTracer) {
        Assertions.assertThat((long)cursorTracer.pins()).isEqualTo(2L);
        Assertions.assertThat((long)cursorTracer.hits()).isEqualTo(2L);
        Assertions.assertThat((long)cursorTracer.unpins()).isEqualTo(2L);
    }

    private void assertZeroCursor(PageCursorTracer cursorTracer) {
        Assertions.assertThat((long)cursorTracer.pins()).isZero();
        Assertions.assertThat((long)cursorTracer.hits()).isZero();
        Assertions.assertThat((long)cursorTracer.unpins()).isZero();
        Assertions.assertThat((long)cursorTracer.faults()).isZero();
    }
}

