/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.GraphDatabaseServiceCleaner;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
class CreateAndDeleteNodesIT {
    @Inject
    private GraphDatabaseService db;

    CreateAndDeleteNodesIT() {
    }

    @Test
    void creatingAndDeletingEntitiesShouldNotThrow() {
        try (Transaction bobTransaction = this.db.beginTx();){
            Node myNode = bobTransaction.createNode();
            myNode.setProperty("Name", (Object)"Bob");
            myNode.createRelationshipTo(bobTransaction.createNode(), (RelationshipType)RelTypes.ASD);
            bobTransaction.commit();
        }
        GraphDatabaseServiceCleaner.cleanupAllRelationshipsAndNodes((GraphDatabaseService)this.db);
    }

    static enum RelTypes implements RelationshipType
    {
        ASD;

    }
}

