/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.assertj.core.api.Assertions;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;

public class IndexingTestUtil {
    public static void assertOnlyDefaultTokenIndexesExists(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            List indexes = StreamSupport.stream(tx.schema().getIndexes().spliterator(), false).collect(Collectors.toList());
            Assertions.assertThat((long)indexes.stream().filter(IndexDefinition::isNodeIndex).count()).isEqualTo(1L);
            Assertions.assertThat((long)indexes.stream().filter(IndexDefinition::isRelationshipIndex).count()).isEqualTo(1L);
            Assertions.assertThat((int)indexes.size()).isEqualTo(2);
        }
    }

    public static void dropAllIndexes(GraphDatabaseService db) {
        IndexingTestUtil.dropIndexes(db, Predicates.alwaysTrue());
    }

    public static void dropTokenIndexes(GraphDatabaseService db) {
        IndexingTestUtil.dropIndexes(db, index -> index.isRelationshipIndex() || index.isNodeIndex());
    }

    private static void dropIndexes(GraphDatabaseService db, Predicate<IndexDefinition> condition) {
        try (Transaction tx = db.beginTx();){
            tx.schema().getIndexes().forEach(index -> {
                if (condition.test((IndexDefinition)index)) {
                    index.drop();
                }
            });
            tx.commit();
        }
    }
}

