/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.DbmsController;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;

@DbmsExtension
@ExtendWith(value={RandomExtension.class})
public class LabelScanStoreChaosIT {
    @Inject
    private RandomRule random;
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private DbmsController controller;

    @Test
    void shouldRebuildDeletedLabelScanStoreOnStartup() {
        Node node1 = this.createLabeledNode(Labels.First);
        Node node2 = this.createLabeledNode(Labels.First);
        Node node3 = this.createLabeledNode(Labels.First);
        this.deleteNode(node2);
        this.controller.restartDbms(builder -> {
            try {
                this.fs.deleteFile(LabelScanStoreChaosIT.storeFile(this.db.databaseLayout()));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return builder;
        });
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new Node[]{node1, node3}), this.getAllNodesWithLabel(Labels.First));
    }

    @Test
    void rebuildCorruptedLabelScanStoreToStartup() {
        Node node = this.createLabeledNode(Labels.First);
        this.controller.restartDbms(builder -> {
            this.scrambleFile(LabelScanStoreChaosIT.storeFile(this.db.databaseLayout()));
            return builder;
        });
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new Node[]{node}), this.getAllNodesWithLabel(Labels.First));
    }

    private static Path storeFile(DatabaseLayout databaseLayout) {
        return databaseLayout.labelScanStore();
    }

    private Node createLabeledNode(Label ... labels) {
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode(labels);
            tx.commit();
            Node node2 = node;
            return node2;
        }
    }

    private Set<Node> getAllNodesWithLabel(Label label) {
        try (Transaction tx = this.db.beginTx();){
            Set set = Iterators.asSet((Iterator)tx.findNodes(label));
            return set;
        }
    }

    private void scrambleFile(Path path) {
        LabelScanStoreChaosIT.scrambleFile(this.random.random(), path);
    }

    private void deleteNode(Node node) {
        try (Transaction tx = this.db.beginTx();){
            tx.getNodeById(node.getId()).delete();
            tx.commit();
        }
    }

    public static void scrambleFile(Random random, Path file) {
        try (FileChannel channel = FileChannel.open(file, StandardOpenOption.READ, StandardOpenOption.WRITE);){
            byte[] bytes = new byte[(int)channel.size()];
            LabelScanStoreChaosIT.putRandomBytes(random, bytes);
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            channel.position(0L);
            FileUtils.writeAll((FileChannel)channel, (ByteBuffer)buffer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void putRandomBytes(Random random, byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)random.nextInt();
        }
    }

    private static enum Labels implements Label
    {
        First,
        Second,
        Third;

    }
}

