/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.Arrays;
import org.eclipse.collections.api.iterator.LongIterator;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.configuration.Config;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.PropertyIndexProviderCompatibilityTestSuite;
import org.neo4j.kernel.api.index.TestNodePropertyAccessor;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.index.schema.NodeValueIterator;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.Values;

@Ignore(value="Not a test. This is a compatibility suite that provides test cases for verifying IndexProvider implementations. Each index provider that is to be tested by this suite must create their own test class extending PropertyIndexProviderCompatibilityTestSuite. The @Ignore annotation doesn't prevent these tests to run, it rather removes some annoying errors or warnings in some IDEs about test classes needing a public zero-arg constructor.")
public class CompositeIndexPopulatorCompatibility
extends PropertyIndexProviderCompatibilityTestSuite.Compatibility {
    CompositeIndexPopulatorCompatibility(PropertyIndexProviderCompatibilityTestSuite testSuite, IndexPrototype prototype) {
        super(testSuite, prototype);
    }

    @Ignore(value="Not a test. This is a compatibility suite")
    public static class Unique
    extends CompositeIndexPopulatorCompatibility {
        Value value1 = Values.of((Object)"value1");
        Value value2 = Values.of((Object)"value2");
        Value value3 = Values.of((Object)"value3");
        int nodeId1 = 3;
        int nodeId2 = 4;

        public Unique(PropertyIndexProviderCompatibilityTestSuite testSuite) {
            super(testSuite, IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)1000, (int[])new int[]{100, 200})));
        }

        @Test
        public void shouldEnforceUniqueConstraintsDirectly() throws Exception {
            IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.defaults());
            this.withPopulator(this.indexProvider.getPopulator(this.descriptor, indexSamplingConfig, ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenNameLookup), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> {
                try {
                    p.add(Arrays.asList(IndexEntryUpdate.add((long)this.nodeId1, (SchemaDescriptorSupplier)this.descriptor.schema(), (Value[])new Value[]{this.value1, this.value2}), IndexEntryUpdate.add((long)this.nodeId2, (SchemaDescriptorSupplier)this.descriptor.schema(), (Value[])new Value[]{this.value1, this.value2})), CursorContext.NULL);
                    TestNodePropertyAccessor propertyAccessor = new TestNodePropertyAccessor((long)this.nodeId1, this.descriptor.schema(), new Value[]{this.value1, this.value2});
                    propertyAccessor.addNode((long)this.nodeId2, this.descriptor.schema(), new Value[]{this.value1, this.value2});
                    p.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL);
                    p.verifyDeferredConstraints((NodePropertyAccessor)propertyAccessor);
                    Assert.fail((String)"expected exception");
                }
                catch (IndexEntryConflictException conflict) {
                    Assert.assertEquals((long)this.nodeId1, (long)conflict.getExistingNodeId());
                    Assert.assertEquals((Object)ValueTuple.of((Value[])new Value[]{this.value1, this.value2}), (Object)conflict.getPropertyValues());
                    Assert.assertEquals((long)this.nodeId2, (long)conflict.getAddedNodeId());
                }
            }), false);
        }

        @Test
        public void shouldNotRestrictUpdatesDifferingOnSecondProperty() throws Exception {
            IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.defaults());
            this.withPopulator(this.indexProvider.getPopulator(this.descriptor, indexSamplingConfig, ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenNameLookup), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> {
                p.add(Arrays.asList(IndexEntryUpdate.add((long)this.nodeId1, (SchemaDescriptorSupplier)this.descriptor.schema(), (Value[])new Value[]{this.value1, this.value2}), IndexEntryUpdate.add((long)this.nodeId2, (SchemaDescriptorSupplier)this.descriptor.schema(), (Value[])new Value[]{this.value1, this.value3})), CursorContext.NULL);
                TestNodePropertyAccessor propertyAccessor = new TestNodePropertyAccessor((long)this.nodeId1, this.descriptor.schema(), new Value[]{this.value1, this.value2});
                propertyAccessor.addNode((long)this.nodeId2, this.descriptor.schema(), new Value[]{this.value1, this.value3});
                p.verifyDeferredConstraints((NodePropertyAccessor)propertyAccessor);
            }));
        }
    }

    @Ignore(value="Not a test. This is a compatibility suite")
    public static class General
    extends CompositeIndexPopulatorCompatibility {
        public General(PropertyIndexProviderCompatibilityTestSuite testSuite) {
            super(testSuite, IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)1000, (int[])new int[]{100, 200})));
        }

        @Test
        public void shouldProvidePopulatorThatAcceptsDuplicateEntries() throws Exception {
            IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.defaults());
            this.withPopulator(this.indexProvider.getPopulator(this.descriptor, indexSamplingConfig, ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenNameLookup), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> p.add(Arrays.asList(IndexEntryUpdate.add((long)1L, (SchemaDescriptorSupplier)this.descriptor.schema(), (Value[])new Value[]{Values.of((Object)"v1"), Values.of((Object)"v2")}), IndexEntryUpdate.add((long)2L, (SchemaDescriptorSupplier)this.descriptor.schema(), (Value[])new Value[]{Values.of((Object)"v1"), Values.of((Object)"v2")})), CursorContext.NULL)));
            try (IndexAccessor accessor = this.indexProvider.getOnlineAccessor(this.descriptor, indexSamplingConfig, this.tokenNameLookup);
                 ValueIndexReader reader = accessor.newValueReader();
                 NodeValueIterator nodes = new NodeValueIterator();){
                reader.query(QueryContext.NULL_CONTEXT, (IndexProgressor.EntityValueClient)nodes, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)1, (Object)"v1"), PropertyIndexQuery.exact((int)1, (Object)"v2")});
                Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L, 2L}), (Object)PrimitiveLongCollections.toSet((LongIterator)nodes));
            }
        }
    }
}

