/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProviderCompatibilityTestSuite;
import org.neo4j.kernel.api.index.MinimalIndexAccessor;
import org.neo4j.kernel.api.schema.SchemaTestUtil;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;

@Ignore(value="Not a test. This is a compatibility suite that provides test cases for verifying IndexProvider implementations. Each index provider that is to be tested by this suite must create their own test class extending IndexProviderCompatibilityTestSuite. The @Ignore annotation doesn't prevent these tests to run, it rather removes some annoying errors or warnings in some IDEs about test classes needing a public zero-arg constructor.")
public class MinimalIndexAccessorCompatibility
extends IndexProviderCompatibilityTestSuite.Compatibility {
    public MinimalIndexAccessorCompatibility(IndexProviderCompatibilityTestSuite testSuite, IndexPrototype indexPrototype) {
        super(testSuite, indexPrototype);
    }

    @Ignore(value="Not a test. This is a compatibility suite")
    public static class ReadOnly
    extends MinimalIndexAccessorCompatibility {
        public ReadOnly(IndexProviderCompatibilityTestSuite testSuite) {
            super(testSuite, testSuite.indexPrototype());
        }

        @Override
        public void additionalConfig(Config.Builder configBuilder) {
            configBuilder.set(GraphDatabaseSettings.read_only_database_default, (Object)true);
        }

        @Test
        public void dropShouldBeBlockedIfReadOnly() {
            MinimalIndexAccessor minimalIndexAccessor = this.indexProvider.getMinimalIndexAccessor(this.descriptor);
            IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((MinimalIndexAccessor)minimalIndexAccessor).drop());
            Assertions.assertThat((Throwable)e).hasMessageContaining("read-only");
        }
    }

    @Ignore(value="Not a test. This is a compatibility suite")
    public static class General
    extends MinimalIndexAccessorCompatibility {
        private MinimalIndexAccessor minimalIndexAccessor;

        public General(IndexProviderCompatibilityTestSuite testSuite) {
            super(testSuite, testSuite.indexPrototype());
        }

        @Before
        public void before() throws IOException {
            IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.defaults());
            IndexPopulator populator = this.indexProvider.getPopulator(this.descriptor, indexSamplingConfig, ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE, SchemaTestUtil.SIMPLE_NAME_LOOKUP);
            populator.create();
            populator.close(true, CursorContext.NULL);
            this.minimalIndexAccessor = this.indexProvider.getMinimalIndexAccessor(this.descriptor);
        }

        @Test
        public void indexDropperMustDropIndex() throws IOException {
            Path rootDirectory = this.indexProvider.directoryStructure().rootDirectory();
            Path[] files = this.fs.listFiles(rootDirectory);
            Assert.assertEquals((long)1L, (long)files.length);
            this.minimalIndexAccessor.drop();
            files = this.fs.listFiles(rootDirectory);
            Assert.assertEquals((long)0L, (long)files.length);
        }

        @Test
        public void indexDropperMustProvideIndexConfiguration() {
            Map dropperConfiguration = this.minimalIndexAccessor.indexConfig();
            Assert.assertEquals((Object)this.descriptor.getIndexConfig().asMap(), (Object)dropperConfiguration);
        }
    }
}

