/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.Race;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;

class TestConcurrentRelationshipChainLoadingIssue {
    private final int relCount = 2;

    TestConcurrentRelationshipChainLoadingIssue() {
    }

    @Test
    void tryToTriggerRelationshipLoadingStoppingMidWay() throws Throwable {
        this.tryToTriggerRelationshipLoadingStoppingMidWay(50);
    }

    @Test
    void tryToTriggerRelationshipLoadingStoppingMidWayForDenseNodeRepresentation() throws Throwable {
        this.tryToTriggerRelationshipLoadingStoppingMidWay(1);
    }

    private void tryToTriggerRelationshipLoadingStoppingMidWay(int denseNodeThreshold) throws Throwable {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder().impermanent().setConfig(GraphDatabaseSettings.dense_node_threshold, (Object)denseNodeThreshold).build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        Node node = this.createNodeWithRelationships(db);
        this.checkStateToHelpDiagnoseFlakyTest(db, node);
        long end = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(5L);
        for (int iterations = 0; System.currentTimeMillis() < end && iterations < 100; ++iterations) {
            this.tryOnce(db, node);
        }
        managementService.shutdown();
    }

    private void checkStateToHelpDiagnoseFlakyTest(GraphDatabaseAPI db, Node node) {
        this.loadNode(db, node);
        this.loadNode(db, node);
    }

    private void loadNode(GraphDatabaseAPI db, Node node) {
        try (Transaction tx = db.beginTx();){
            Iterables.count((Iterable)tx.getNodeById(node.getId()).getRelationships());
        }
    }

    private void tryOnce(GraphDatabaseAPI db, Node node) throws Throwable {
        Race race = new Race().withRandomStartDelays();
        race.addContestants(Runtime.getRuntime().availableProcessors(), () -> {
            try (Transaction tx = db.beginTx();){
                Assertions.assertEquals((long)2L, (long)Iterables.count((Iterable)tx.getNodeById(node.getId()).getRelationships()));
            }
        });
        race.go();
    }

    private Node createNodeWithRelationships(GraphDatabaseAPI db) {
        try (Transaction tx = db.beginTx();){
            int i;
            Node node = tx.createNode();
            for (i = 0; i < 1; ++i) {
                node.createRelationshipTo(node, (RelationshipType)MyRelTypes.TEST);
            }
            for (i = 0; i < 1; ++i) {
                node.createRelationshipTo(node, (RelationshipType)MyRelTypes.TEST2);
            }
            tx.commit();
            Node node2 = node;
            return node2;
        }
    }
}

