/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import java.util.function.Function;
import java.util.stream.Stream;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.kernel.impl.core.NodeEntity;
import org.neo4j.kernel.impl.core.RelationshipEntity;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
public class EntityAccessRequireTransactionIT {
    @Inject
    private GraphDatabaseAPI databaseAPI;
    private InternalTransaction transaction;

    static Stream<EntityFactory<? extends Entity>> entities() {
        return Stream.of(tx -> new NodeEntity(tx, 1L), tx -> new RelationshipEntity(tx, 1L));
    }

    @BeforeEach
    void setUp() {
        this.transaction = (InternalTransaction)this.databaseAPI.beginTx();
    }

    @AfterEach
    void tearDown() {
        if (this.transaction != null) {
            this.transaction.close();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"entities"})
    void entityIdAccessWithoutTransaction(EntityFactory<Entity> entityFactory) {
        Entity entity = this.getDetachedEntity(entityFactory);
        Assertions.assertDoesNotThrow(() -> ((Entity)entity).getId());
    }

    @ParameterizedTest
    @MethodSource(value={"entities"})
    void requireTransactionToAccessAllProperties(EntityFactory<Entity> entityFactory) {
        Entity entity = this.getDetachedEntity(entityFactory);
        Assertions.assertThrows(NotInTransactionException.class, () -> ((Entity)entity).getAllProperties());
    }

    @ParameterizedTest
    @MethodSource(value={"entities"})
    void requireTransactionToAccessCheckPropertyExistence(EntityFactory<Entity> entityFactory) {
        Entity entity = this.getDetachedEntity(entityFactory);
        Assertions.assertThrows(NotInTransactionException.class, () -> entity.hasProperty("any"));
    }

    @ParameterizedTest
    @MethodSource(value={"entities"})
    void requireTransactionToAccessGetProperty(EntityFactory<Entity> entityFactory) {
        Entity entity = this.getDetachedEntity(entityFactory);
        Assertions.assertThrows(NotInTransactionException.class, () -> entity.getProperty("any"));
    }

    @ParameterizedTest
    @MethodSource(value={"entities"})
    void requireTransactionToAccessGetPropertyWithDefaultValue(EntityFactory<Entity> entityFactory) {
        Entity entity = this.getDetachedEntity(entityFactory);
        Assertions.assertThrows(NotInTransactionException.class, () -> entity.getProperty("any", (Object)"foo"));
    }

    @ParameterizedTest
    @MethodSource(value={"entities"})
    void requireTransactionToAccessSetProperty(EntityFactory<Entity> entityFactory) {
        Entity entity = this.getDetachedEntity(entityFactory);
        Assertions.assertThrows(NotInTransactionException.class, () -> entity.setProperty("any", (Object)"bar"));
    }

    @ParameterizedTest
    @MethodSource(value={"entities"})
    void requireTransactionToAccessRemoveProperty(EntityFactory<Entity> entityFactory) {
        Entity entity = this.getDetachedEntity(entityFactory);
        Assertions.assertThrows(NotInTransactionException.class, () -> entity.removeProperty("any"));
    }

    @ParameterizedTest
    @MethodSource(value={"entities"})
    void requireTransactionToAccessAllPropertyKeys(EntityFactory<Entity> entityFactory) {
        Entity entity = this.getDetachedEntity(entityFactory);
        Assertions.assertThrows(NotInTransactionException.class, () -> ((Entity)entity).getPropertyKeys());
    }

    @ParameterizedTest
    @MethodSource(value={"entities"})
    void requireTransactionToAccessMultipleProperties(EntityFactory<Entity> entityFactory) {
        Entity entity = this.getDetachedEntity(entityFactory);
        Assertions.assertThrows(NotInTransactionException.class, () -> entity.getProperties(new String[]{"a", "b", "c"}));
    }

    private Entity getDetachedEntity(EntityFactory<Entity> entityFactory) {
        Entity entity = (Entity)entityFactory.apply((Entity)this.transaction);
        this.transaction.close();
        return entity;
    }

    @FunctionalInterface
    private static interface EntityFactory<T>
    extends Function<InternalTransaction, Entity> {
    }
}

