/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.dbms.DatabaseStateService;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreFileChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.io.fs.WritableChecksumChannel;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.database.LogEntryWriterFactory;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.SimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.FlushablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionLogWriter;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.entry.IncompleteLogHeaderException;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.entry.UnsupportedLogVersionException;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointInfo;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.StoreIdProvider;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;

@Neo4jLayoutExtension
@ExtendWith(value={RandomExtension.class})
class RecoveryCorruptedTransactionLogIT {
    @Inject
    private DefaultFileSystemAbstraction fileSystem;
    @Inject
    private DatabaseLayout databaseLayout;
    @Inject
    private RandomRule random;
    private static final int HEADER_OFFSET = 64;
    private final AssertableLogProvider logProvider = new AssertableLogProvider(true);
    private final RecoveryMonitor recoveryMonitor = new RecoveryMonitor();
    private final Monitors monitors = new Monitors();
    private LogFiles logFiles;
    private TestDatabaseManagementServiceBuilder databaseFactory;
    private StorageEngineFactory storageEngineFactory;
    private long txOffsetAfterStart;

    RecoveryCorruptedTransactionLogIT() {
    }

    @BeforeEach
    void setUp() {
        this.monitors.addMonitorListener((Object)this.recoveryMonitor, new String[0]);
        this.databaseFactory = new TestDatabaseManagementServiceBuilder(this.databaseLayout).setInternalLogProvider((LogProvider)this.logProvider).setMonitors(this.monitors).setFileSystem((FileSystemAbstraction)this.fileSystem);
        this.txOffsetAfterStart = this.startStopDatabaseAndGetTxOffset();
    }

    @Test
    void evenTruncateNewerTransactionLogFile() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(this.getStoreId(database));
        TransactionIdStore transactionIdStore = RecoveryCorruptedTransactionLogIT.getTransactionIdStore(database);
        long lastClosedTransactionBeforeStart = transactionIdStore.getLastClosedTransactionId();
        for (int i = 0; i < 10; ++i) {
            RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        }
        long numberOfClosedTransactions = RecoveryCorruptedTransactionLogIT.getTransactionIdStore(database).getLastClosedTransactionId() - lastClosedTransactionBeforeStart;
        managementService.shutdown();
        this.removeLastCheckpointRecordFromLastLogFile();
        this.addRandomBytesToLastLogFile(this::randomBytes);
        this.startStopDbRecoveryOfCorruptedLogs();
        Assertions.assertEquals((long)numberOfClosedTransactions, (long)this.recoveryMonitor.getNumberOfRecoveredTransactions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void doNotTruncateNewerTransactionLogFileWhenFailOnError() throws IOException {
        DatabaseManagementService managementService1 = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService1.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(this.getStoreId(database));
        for (int i = 0; i < 10; ++i) {
            RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        }
        managementService1.shutdown();
        this.removeLastCheckpointRecordFromLastLogFile();
        this.addRandomBytesToLastLogFile(this::randomInvalidVersionsBytes);
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        try {
            DatabaseStateService dbStateService = (DatabaseStateService)db.getDependencyResolver().resolveDependency(DatabaseStateService.class);
            Assertions.assertTrue((boolean)dbStateService.causeOfFailure(db.databaseId()).isPresent());
            LogAssertions.assertThat((Throwable)((Throwable)dbStateService.causeOfFailure(db.databaseId()).get())).hasRootCauseInstanceOf(UnsupportedLogVersionException.class);
        }
        finally {
            managementService.shutdown();
        }
    }

    @Test
    void truncateNewerTransactionLogFileWhenForced() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        TransactionIdStore transactionIdStore = RecoveryCorruptedTransactionLogIT.getTransactionIdStore(database);
        long numberOfClosedTransactionsAfterStartup = transactionIdStore.getLastClosedTransactionId();
        this.logFiles = this.buildDefaultLogFiles(this.getStoreId(database));
        for (int i = 0; i < 10; ++i) {
            RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        }
        long numberOfTransactionsToRecover = transactionIdStore.getLastClosedTransactionId() - numberOfClosedTransactionsAfterStartup;
        managementService.shutdown();
        this.removeLastCheckpointRecordFromLastLogFile();
        Supplier<Byte> randomBytesSupplier = this::randomBytes;
        BytesCaptureSupplier capturingSupplier = new BytesCaptureSupplier(randomBytesSupplier);
        this.addRandomBytesToLastLogFile(capturingSupplier);
        Assertions.assertFalse((boolean)this.recoveryMonitor.wasRecoveryRequired());
        this.startStopDbRecoveryOfCorruptedLogs();
        try {
            Assertions.assertEquals((long)numberOfTransactionsToRecover, (long)this.recoveryMonitor.getNumberOfRecoveredTransactions());
            Assertions.assertTrue((boolean)this.recoveryMonitor.wasRecoveryRequired());
            LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Fail to read transaction log version 0.", "Fail to read transaction log version 0. Last valid transaction start offset is: " + (5548L + this.txOffsetAfterStart) + "."});
        }
        catch (Throwable t) {
            throw new RuntimeException("Generated random bytes: " + capturingSupplier.getCapturedBytes(), t);
        }
    }

    @ParameterizedTest(name="[{index}] ({0})")
    @MethodSource(value={"corruptedLogEntryWriters"})
    void recoverFirstCorruptedTransactionSingleFileNoCheckpoint(String testName, LogEntryWriterWrapper logEntryWriterWrapper) throws IOException {
        this.addCorruptedCommandsToLastLogFile(logEntryWriterWrapper);
        this.startStopDbRecoveryOfCorruptedLogs();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Fail to read transaction log version 0.", "Fail to read first transaction of log version 0.", "Recovery required from position LogPosition{logVersion=0, byteOffset=" + this.txOffsetAfterStart + "}", "Fail to recover all transactions. Any later transactions after position LogPosition{logVersion=0, byteOffset=" + this.txOffsetAfterStart + "} are unreadable and will be truncated."});
        this.logFiles = this.buildDefaultLogFiles(StoreId.UNKNOWN);
        Assertions.assertEquals((long)0L, (long)this.logFiles.getLogFile().getHighestLogVersion());
        Assertions.assertEquals((long)640L, (long)Files.size(this.logFiles.getCheckpointFile().getCurrentFile()));
    }

    @Test
    void failToStartWithTransactionLogsWithDataAfterLastEntry() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(this.getStoreId(database));
        RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        managementService.shutdown();
        this.writeRandomBytesAfterLastCommandInLastLogFile(() -> ByteBuffer.wrap(new byte[]{1, 2, 3, 4, 5}));
        this.startStopDatabase();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).assertExceptionForLogMessage("Fail to read transaction log version 0.").hasMessageContaining("Transaction log files with version 0 has some data available after last readable log entry. Last readable position " + (996L + this.txOffsetAfterStart));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void startWithTransactionLogsWithDataAfterLastEntryAndCorruptedLogsRecoveryEnabled() throws IOException {
        long initialTransactionOffset = this.txOffsetAfterStart + 996L;
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(this.getStoreId(database));
        RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        Assertions.assertEquals((long)initialTransactionOffset, (long)this.getLastClosedTransactionOffset(database));
        managementService.shutdown();
        this.writeRandomBytesAfterLastCommandInLastLogFile(() -> ByteBuffer.wrap(new byte[]{1, 2, 3, 4, 5}));
        managementService = this.databaseFactory.setConfig(GraphDatabaseInternalSettings.fail_on_corrupted_log_files, (Object)false).build();
        try {
            LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Recovery required from position LogPosition{logVersion=0, byteOffset=" + initialTransactionOffset + "}"}).assertExceptionForLogMessage("Fail to read transaction log version 0.").hasMessageContaining("Transaction log files with version 0 has some data available after last readable log entry. Last readable position " + initialTransactionOffset);
            GraphDatabaseAPI restartedDb = (GraphDatabaseAPI)managementService.database("neo4j");
            Assertions.assertEquals((long)initialTransactionOffset, (long)this.getLastClosedTransactionOffset(restartedDb));
        }
        finally {
            managementService.shutdown();
        }
    }

    @Test
    void failToStartWithNotLastTransactionLogHavingZerosInTheEnd() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(this.getStoreId(database));
        RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        managementService.shutdown();
        try (Lifespan lifespan = new Lifespan(new Lifecycle[]{this.logFiles});){
            Path originalFile = this.logFiles.getLogFile().getHighestLogFile();
            this.logFiles.getLogFile().rotate();
            try (StoreFileChannel writeChannel = this.fileSystem.write(originalFile);){
                writeChannel.position(writeChannel.size());
                for (int i = 0; i < 10; ++i) {
                    writeChannel.writeAll(ByteBuffer.wrap(new byte[]{0, 0, 0, 0, 0}));
                }
            }
        }
        this.startStopDatabase();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).assertExceptionForLogMessage("Fail to read transaction log version 0.").hasMessageContaining("Transaction log files with version 0 has 50 unreadable bytes");
    }

    @Test
    void startWithNotLastTransactionLogHavingZerosInTheEndAndCorruptedLogRecoveryEnabled() throws IOException {
        long originalLogDataLength;
        Path firstLogFile;
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(this.getStoreId(database));
        RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        managementService.shutdown();
        try (Lifespan lifespan = new Lifespan(new Lifecycle[]{this.logFiles});){
            LogFile logFile = this.logFiles.getLogFile();
            LogPosition readablePosition = this.getLastReadablePosition(logFile);
            firstLogFile = this.logFiles.getLogFile().getHighestLogFile();
            originalLogDataLength = readablePosition.getByteOffset();
            logFile.rotate();
            try (StoreFileChannel writeChannel = this.fileSystem.write(firstLogFile);){
                writeChannel.position(writeChannel.size());
                for (int i = 0; i < 10; ++i) {
                    writeChannel.writeAll(ByteBuffer.wrap(new byte[]{0, 0, 0, 0, 0}));
                }
            }
        }
        this.startStopDbRecoveryOfCorruptedLogs();
        Assertions.assertEquals((long)originalLogDataLength, (long)this.fileSystem.getFileSize(firstLogFile));
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Recovery required from position LogPosition{logVersion=0, byteOffset=" + (996L + this.txOffsetAfterStart) + "}"}).assertExceptionForLogMessage("Fail to read transaction log version 0.").hasMessage("Transaction log files with version 0 has 50 unreadable bytes. Was able to read upto " + (996L + this.txOffsetAfterStart) + " but " + (1046L + this.txOffsetAfterStart) + " is available.");
    }

    @Test
    void startWithoutProblemsIfRotationForcedBeforeFileEnd() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(this.getStoreId(database));
        RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        managementService.shutdown();
        try (Lifespan lifespan = new Lifespan(new Lifecycle[]{this.logFiles});){
            Path originalFile = this.logFiles.getLogFile().getHighestLogFile();
            try (StoreFileChannel writeChannel = this.fileSystem.write(originalFile);){
                writeChannel.position(writeChannel.size());
                for (int i = 0; i < 10; ++i) {
                    writeChannel.writeAll(ByteBuffer.wrap(new byte[]{0, 0, 0, 0, 0}));
                }
            }
            this.logFiles.getLogFile().rotate();
        }
        this.startStopDatabase();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).doesNotContainMessage("Fail to read transaction log version 0.");
    }

    @Test
    void startWithoutProblemsIfRotationForcedBeforeFileEndAndCorruptedLogFilesRecoveryEnabled() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(this.getStoreId(database));
        RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        managementService.shutdown();
        try (Lifespan lifespan = new Lifespan(new Lifecycle[]{this.logFiles});){
            Path originalFile = this.logFiles.getLogFile().getHighestLogFile();
            try (StoreFileChannel writeChannel = this.fileSystem.write(originalFile);){
                writeChannel.position(writeChannel.size());
                for (int i = 0; i < 10; ++i) {
                    writeChannel.writeAll(ByteBuffer.wrap(new byte[]{0, 0, 0, 0, 0}));
                }
            }
            this.logFiles.getLogFile().rotate();
        }
        this.startStopDbRecoveryOfCorruptedLogs();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).doesNotContainMessage("Fail to read transaction log version 0.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void failToRecoverFirstCorruptedTransactionSingleFileNoCheckpointIfFailOnCorruption() throws IOException {
        this.addCorruptedCommandsToLastLogFile(new CorruptedLogEntryWrapper());
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        try {
            DatabaseStateService dbStateService = (DatabaseStateService)db.getDependencyResolver().resolveDependency(DatabaseStateService.class);
            Assertions.assertTrue((boolean)dbStateService.causeOfFailure(db.databaseId()).isPresent());
            LogAssertions.assertThat((Throwable)((Throwable)dbStateService.causeOfFailure(db.databaseId()).get())).hasRootCauseInstanceOf(NegativeArraySizeException.class);
        }
        finally {
            managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void failToRecoverFirstCorruptedTransactionSingleFileNoCheckpointIfFailOnCorruptionVersion() throws IOException {
        this.addCorruptedCommandsToLastLogFile(new CorruptedLogEntryVersionWrapper());
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        try {
            DatabaseStateService dbStateService = (DatabaseStateService)db.getDependencyResolver().resolveDependency(DatabaseStateService.class);
            Assertions.assertTrue((boolean)dbStateService.causeOfFailure(db.databaseId()).isPresent());
            LogAssertions.assertThat((Throwable)((Throwable)dbStateService.causeOfFailure(db.databaseId()).get())).hasRootCauseInstanceOf(UnsupportedLogVersionException.class);
        }
        finally {
            managementService.shutdown();
        }
    }

    @ParameterizedTest(name="[{index}] ({0})")
    @MethodSource(value={"corruptedLogEntryWriters"})
    void recoverNotAFirstCorruptedTransactionSingleFileNoCheckpoint(String testName, LogEntryWriterWrapper logEntryWriterWrapper) throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(this.getStoreId(database));
        TransactionIdStore transactionIdStore = RecoveryCorruptedTransactionLogIT.getTransactionIdStore(database);
        long lastClosedTransactionBeforeStart = transactionIdStore.getLastClosedTransactionId();
        for (int i = 0; i < 10; ++i) {
            RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        }
        long numberOfTransactions = transactionIdStore.getLastClosedTransactionId() - lastClosedTransactionBeforeStart;
        managementService.shutdown();
        Path highestLogFile = this.logFiles.getLogFile().getHighestLogFile();
        long originalFileLength = this.getLastReadablePosition(highestLogFile).getByteOffset();
        this.removeLastCheckpointRecordFromLastLogFile();
        this.addCorruptedCommandsToLastLogFile(logEntryWriterWrapper);
        long modifiedFileLength = this.fileSystem.getFileSize(highestLogFile);
        LogAssertions.assertThat((long)modifiedFileLength).isGreaterThan(originalFileLength);
        this.startStopDbRecoveryOfCorruptedLogs();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Fail to read transaction log version 0.", "Recovery required from position LogPosition{logVersion=0, byteOffset=" + this.txOffsetAfterStart + "}", "Fail to recover all transactions.", "Any later transaction after LogPosition{logVersion=0, byteOffset=" + (6117L + this.txOffsetAfterStart) + "} are unreadable and will be truncated."});
        Assertions.assertEquals((long)0L, (long)this.logFiles.getLogFile().getHighestLogVersion());
        Assertions.assertEquals((long)numberOfTransactions, (long)this.recoveryMonitor.getNumberOfRecoveredTransactions());
        Assertions.assertEquals((long)originalFileLength, (long)this.fileSystem.getFileSize(highestLogFile));
        Assertions.assertEquals((long)640L, (long)Files.size(this.logFiles.getCheckpointFile().getCurrentFile()));
    }

    @ParameterizedTest(name="[{index}] ({0})")
    @MethodSource(value={"corruptedLogEntryWriters"})
    void recoverNotAFirstCorruptedTransactionMultipleFilesNoCheckpoints(String testName, LogEntryWriterWrapper logEntryWriterWrapper) throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(this.getStoreId(database));
        TransactionIdStore transactionIdStore = RecoveryCorruptedTransactionLogIT.getTransactionIdStore(database);
        long lastClosedTransactionBeforeStart = transactionIdStore.getLastClosedTransactionId();
        RecoveryCorruptedTransactionLogIT.generateTransactionsAndRotate(database, 3);
        for (int i = 0; i < 7; ++i) {
            RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        }
        long numberOfTransactions = transactionIdStore.getLastClosedTransactionId() - lastClosedTransactionBeforeStart;
        managementService.shutdown();
        Path highestLogFile = this.logFiles.getLogFile().getHighestLogFile();
        long originalFileLength = this.getLastReadablePosition(highestLogFile).getByteOffset();
        this.removeLastCheckpointRecordFromLastLogFile();
        this.addCorruptedCommandsToLastLogFile(logEntryWriterWrapper);
        long modifiedFileLength = this.fileSystem.getFileSize(highestLogFile);
        LogAssertions.assertThat((long)modifiedFileLength).isGreaterThan(originalFileLength);
        this.startStopDbRecoveryOfCorruptedLogs();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Fail to read transaction log version 3.", "Recovery required from position LogPosition{logVersion=0, byteOffset=" + this.txOffsetAfterStart + "}", "Fail to recover all transactions.", "Any later transaction after LogPosition{logVersion=3, byteOffset=4616} are unreadable and will be truncated."});
        Assertions.assertEquals((long)3L, (long)this.logFiles.getLogFile().getHighestLogVersion());
        Assertions.assertEquals((long)numberOfTransactions, (long)this.recoveryMonitor.getNumberOfRecoveredTransactions());
        Assertions.assertEquals((long)originalFileLength, (long)this.fileSystem.getFileSize(highestLogFile));
        Assertions.assertEquals((long)640L, (long)Files.size(this.logFiles.getCheckpointFile().getCurrentFile()));
    }

    @ParameterizedTest(name="[{index}] ({0})")
    @MethodSource(value={"corruptedLogEntryWriters"})
    void recoverNotAFirstCorruptedTransactionMultipleFilesMultipleCheckpoints(String testName, LogEntryWriterWrapper logEntryWriterWrapper) throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(this.getStoreId(database));
        long transactionsToRecover = 7L;
        RecoveryCorruptedTransactionLogIT.generateTransactionsAndRotateWithCheckpoint(database, 3);
        int i = 0;
        while ((long)i < transactionsToRecover) {
            RecoveryCorruptedTransactionLogIT.generateTransaction(database);
            ++i;
        }
        managementService.shutdown();
        Path highestLogFile = this.logFiles.getLogFile().getHighestLogFile();
        long originalFileLength = this.getLastReadablePosition(highestLogFile).getByteOffset();
        this.removeLastCheckpointRecordFromLastLogFile();
        this.addCorruptedCommandsToLastLogFile(logEntryWriterWrapper);
        long modifiedFileLength = this.fileSystem.getFileSize(highestLogFile);
        LogAssertions.assertThat((long)modifiedFileLength).isGreaterThan(originalFileLength);
        this.startStopDbRecoveryOfCorruptedLogs();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Fail to read transaction log version 3.", "Recovery required from position LogPosition{logVersion=3, byteOffset=633}", "Fail to recover all transactions.", "Any later transaction after LogPosition{logVersion=3, byteOffset=4616} are unreadable and will be truncated."});
        Assertions.assertEquals((long)3L, (long)this.logFiles.getLogFile().getHighestLogVersion());
        Assertions.assertEquals((long)transactionsToRecover, (long)this.recoveryMonitor.getNumberOfRecoveredTransactions());
        Assertions.assertEquals((long)originalFileLength, (long)this.fileSystem.getFileSize(highestLogFile));
        Assertions.assertEquals((long)1216L, (long)Files.size(this.logFiles.getCheckpointFile().getCurrentFile()));
    }

    @ParameterizedTest(name="[{index}] ({0})")
    @MethodSource(value={"corruptedLogEntryWriters"})
    void recoverFirstCorruptedTransactionAfterCheckpointInLastLogFile(String testName, LogEntryWriterWrapper logEntryWriterWrapper) throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(this.getStoreId(database));
        RecoveryCorruptedTransactionLogIT.generateTransactionsAndRotate(database, 5);
        managementService.shutdown();
        Path highestLogFile = this.logFiles.getLogFile().getHighestLogFile();
        long originalFileLength = this.getLastReadablePosition(highestLogFile).getByteOffset();
        this.addCorruptedCommandsToLastLogFile(logEntryWriterWrapper);
        long modifiedFileLength = this.fileSystem.getFileSize(highestLogFile);
        LogAssertions.assertThat((long)modifiedFileLength).isGreaterThan(originalFileLength);
        this.startStopDbRecoveryOfCorruptedLogs();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Fail to read transaction log version 5.", "Fail to read first transaction of log version 5.", "Recovery required from position LogPosition{logVersion=5, byteOffset=633}", "Fail to recover all transactions. Any later transactions after position LogPosition{logVersion=5, byteOffset=633} are unreadable and will be truncated."});
        Assertions.assertEquals((long)5L, (long)this.logFiles.getLogFile().getHighestLogVersion());
        Assertions.assertEquals((long)originalFileLength, (long)this.fileSystem.getFileSize(highestLogFile));
        Assertions.assertEquals((long)832L, (long)Files.size(this.logFiles.getCheckpointFile().getCurrentFile()));
    }

    @Test
    void repetitiveRecoveryOfCorruptedLogs() throws IOException {
        DatabaseManagementService service = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)service.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(this.getStoreId(database));
        RecoveryCorruptedTransactionLogIT.generateTransactionsAndRotate(database, 4, false);
        service.shutdown();
        this.removeLastCheckpointRecordFromLastLogFile();
        for (int expectedRecoveredTransactions = 7; expectedRecoveredTransactions > 0; --expectedRecoveredTransactions) {
            this.truncateBytesFromLastLogFile(1 + this.random.nextInt(10));
            this.startStopDbRecoveryOfCorruptedLogs();
            int numberOfRecoveredTransactions = this.recoveryMonitor.getNumberOfRecoveredTransactions();
            Assertions.assertEquals((int)expectedRecoveredTransactions, (int)numberOfRecoveredTransactions);
            this.removeLastCheckpointRecordFromLastLogFile();
        }
    }

    private StoreId getStoreId(GraphDatabaseAPI database) {
        return ((StoreIdProvider)database.getDependencyResolver().resolveDependency(StoreIdProvider.class)).getStoreId();
    }

    private static TransactionIdStore getTransactionIdStore(GraphDatabaseAPI database) {
        return (TransactionIdStore)database.getDependencyResolver().resolveDependency(TransactionIdStore.class);
    }

    private void removeLastCheckpointRecordFromLastLogFile() throws IOException {
        CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
        Optional checkpoint = checkpointFile.findLatestCheckpoint();
        if (checkpoint.isPresent()) {
            try (StoreFileChannel storeChannel = this.fileSystem.write(checkpointFile.getCurrentFile());){
                LogPosition logPosition = ((CheckpointInfo)checkpoint.get()).getCheckpointEntryPosition();
                storeChannel.truncate(logPosition.getByteOffset());
            }
        }
    }

    private void truncateBytesFromLastLogFile(long bytesToTrim) throws IOException {
        if (this.logFiles.getLogFile().getHighestLogVersion() > 0L) {
            Path highestLogFile = this.logFiles.getLogFile().getHighestLogFile();
            long readableOffset = this.getLastReadablePosition(highestLogFile).getByteOffset();
            if (bytesToTrim > readableOffset) {
                this.fileSystem.deleteFile(highestLogFile);
                if (this.logFiles.logFiles().length > 0) {
                    this.truncateBytesFromLastLogFile(bytesToTrim);
                }
            } else {
                this.fileSystem.truncate(highestLogFile, readableOffset - bytesToTrim);
            }
        }
    }

    private void writeRandomBytesAfterLastCommandInLastLogFile(Supplier<ByteBuffer> source) throws IOException {
        int someRandomPaddingAfterEndOfDataInLogFile = this.random.nextInt(1, 10);
        try (Lifespan lifespan = new Lifespan(new Lifecycle[0]);){
            LogFile transactionLogFile = this.logFiles.getLogFile();
            lifespan.add((Lifecycle)this.logFiles);
            LogPosition position = this.getLastReadablePosition(transactionLogFile);
            try (StoreFileChannel writeChannel = this.fileSystem.write(this.logFiles.getLogFile().getHighestLogFile());){
                writeChannel.position(position.getByteOffset() + (long)someRandomPaddingAfterEndOfDataInLogFile);
                for (int i = 0; i < 10; ++i) {
                    writeChannel.writeAll(source.get());
                }
            }
        }
    }

    private LogPosition getLastReadablePosition(Path logFile) throws IOException {
        VersionAwareLogEntryReader entryReader = new VersionAwareLogEntryReader(this.storageEngineFactory.commandReaderFactory());
        LogFile txLogFile = this.logFiles.getLogFile();
        long logVersion = txLogFile.getLogVersion(logFile);
        LogPosition startPosition = txLogFile.extractHeader(logVersion).getStartPosition();
        try (ReadAheadLogChannel reader = this.openTransactionFileChannel(logVersion, startPosition);){
            while (entryReader.readLogEntry((ReadableClosablePositionAwareChecksumChannel)reader) != null) {
            }
        }
        catch (IncompleteLogHeaderException e) {
            return new LogPosition(logVersion, 0L);
        }
        return entryReader.lastPosition();
    }

    private ReadAheadLogChannel openTransactionFileChannel(long logVersion, LogPosition startPosition) throws IOException {
        PhysicalLogVersionedStoreChannel storeChannel = this.logFiles.getLogFile().openForVersion(logVersion);
        storeChannel.position(startPosition.getByteOffset());
        return new ReadAheadLogChannel((LogVersionedStoreChannel)storeChannel, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    private LogPosition getLastReadablePosition(LogFile logFile) throws IOException {
        VersionAwareLogEntryReader entryReader = new VersionAwareLogEntryReader(this.storageEngineFactory.commandReaderFactory());
        LogPosition startPosition = logFile.extractHeader(this.logFiles.getLogFile().getHighestLogVersion()).getStartPosition();
        try (ReadableLogChannel reader = logFile.getReader(startPosition);){
            while (entryReader.readLogEntry((ReadableClosablePositionAwareChecksumChannel)reader) != null) {
            }
        }
        return entryReader.lastPosition();
    }

    private void addRandomBytesToLastLogFile(Supplier<Byte> byteSource) throws IOException {
        try (Lifespan lifespan = new Lifespan(new Lifecycle[0]);){
            LogFile transactionLogFile = this.logFiles.getLogFile();
            lifespan.add((Lifecycle)this.logFiles);
            FlushablePositionAwareChecksumChannel channel = transactionLogFile.getTransactionLogWriter().getChannel();
            for (int i = 0; i < 10; ++i) {
                channel.put(byteSource.get().byteValue());
            }
        }
    }

    private byte randomInvalidVersionsBytes() {
        int highestVersionByte = Arrays.stream(KernelVersion.values()).mapToInt(KernelVersion::version).max().getAsInt();
        return (byte)this.random.nextInt(highestVersionByte + 1, 127);
    }

    private byte randomBytes() {
        return (byte)this.random.nextInt(-128, 127);
    }

    private void addCorruptedCommandsToLastLogFile(LogEntryWriterWrapper logEntryWriterWrapper) throws IOException {
        PositiveLogFilesBasedLogVersionRepository versionRepository = new PositiveLogFilesBasedLogVersionRepository(this.logFiles);
        LogFiles internalLogFiles = LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem).withLogVersionRepository((LogVersionRepository)versionRepository).withTransactionIdStore((TransactionIdStore)new SimpleTransactionIdStore()).withStoreId(StoreId.UNKNOWN).withCommandReaderFactory(StorageEngineFactory.defaultStorageEngine().commandReaderFactory()).build();
        try (Lifespan lifespan = new Lifespan(new Lifecycle[]{internalLogFiles});){
            LogFile transactionLogFile = internalLogFiles.getLogFile();
            LogEntryWriter realLogEntryWriter = transactionLogFile.getTransactionLogWriter().getWriter();
            LogEntryWriter wrappedLogEntryWriter = logEntryWriterWrapper.wrap(realLogEntryWriter);
            StaticLogEntryWriterFactory factory = new StaticLogEntryWriterFactory(wrappedLogEntryWriter);
            TransactionLogWriter writer = new TransactionLogWriter((FlushablePositionAwareChecksumChannel)realLogEntryWriter.getChannel(), factory);
            ArrayList<Object> commands = new ArrayList<Object>();
            commands.add(new Command.PropertyCommand(new PropertyRecord(1L), new PropertyRecord(2L)));
            commands.add(new Command.NodeCommand(new NodeRecord(2L), new NodeRecord(3L)));
            PhysicalTransactionRepresentation transaction = new PhysicalTransactionRepresentation(commands);
            transaction.setHeader(new byte[0], 0L, 0L, 0L, 0, AuthSubject.ANONYMOUS);
            writer.append((TransactionRepresentation)transaction, 1000L, -559063315);
        }
    }

    private long getLastClosedTransactionOffset(GraphDatabaseAPI database) {
        MetadataProvider metaDataStore = (MetadataProvider)database.getDependencyResolver().resolveDependency(MetadataProvider.class);
        return metaDataStore.getLastClosedTransaction()[2];
    }

    private LogFiles buildDefaultLogFiles(StoreId storeId) throws IOException {
        return LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem).withLogVersionRepository((LogVersionRepository)new SimpleLogVersionRepository()).withTransactionIdStore((TransactionIdStore)new SimpleTransactionIdStore()).withStoreId(storeId).withLogProvider((LogProvider)this.logProvider).withCommandReaderFactory(StorageEngineFactory.defaultStorageEngine().commandReaderFactory()).build();
    }

    private static void generateTransactionsAndRotateWithCheckpoint(GraphDatabaseAPI database, int logFilesToGenerate) throws IOException {
        RecoveryCorruptedTransactionLogIT.generateTransactionsAndRotate(database, logFilesToGenerate, true);
    }

    private static void generateTransactionsAndRotate(GraphDatabaseAPI database, int logFilesToGenerate) throws IOException {
        RecoveryCorruptedTransactionLogIT.generateTransactionsAndRotate(database, logFilesToGenerate, false);
    }

    private static void generateTransactionsAndRotate(GraphDatabaseAPI database, int logFilesToGenerate, boolean checkpoint) throws IOException {
        DependencyResolver resolver = database.getDependencyResolver();
        LogFiles logFiles = (LogFiles)resolver.resolveDependency(LogFiles.class);
        CheckPointer checkpointer = (CheckPointer)resolver.resolveDependency(CheckPointer.class);
        while (logFiles.getLogFile().getHighestLogVersion() < (long)logFilesToGenerate) {
            logFiles.getLogFile().rotate();
            RecoveryCorruptedTransactionLogIT.generateTransaction(database);
            if (!checkpoint) continue;
            checkpointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("testForcedCheckpoint"));
        }
    }

    private static void generateTransaction(GraphDatabaseAPI database) {
        try (Transaction transaction = database.beginTx();){
            Node startNode = transaction.createNode(new Label[]{Label.label((String)"startNode")});
            startNode.setProperty("key", (Object)"value");
            Node endNode = transaction.createNode(new Label[]{Label.label((String)"endNode")});
            endNode.setProperty("key", (Object)"value");
            startNode.createRelationshipTo(endNode, RelationshipType.withName((String)"connects"));
            transaction.commit();
        }
    }

    private void startStopDbRecoveryOfCorruptedLogs() {
        DatabaseManagementService managementService = this.databaseFactory.setConfig(GraphDatabaseInternalSettings.fail_on_corrupted_log_files, (Object)false).build();
        managementService.shutdown();
    }

    private void startStopDatabase() {
        DatabaseManagementService managementService = this.databaseFactory.build();
        this.storageEngineFactory = (StorageEngineFactory)((GraphDatabaseAPI)managementService.database("neo4j")).getDependencyResolver().resolveDependency(StorageEngineFactory.class);
        managementService.shutdown();
    }

    private long startStopDatabaseAndGetTxOffset() {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.storageEngineFactory = (StorageEngineFactory)database.getDependencyResolver().resolveDependency(StorageEngineFactory.class);
        long offset = this.getLastClosedTransactionOffset(database);
        managementService.shutdown();
        return offset;
    }

    private static Stream<Arguments> corruptedLogEntryWriters() {
        return Stream.of(Arguments.of((Object[])new Object[]{"CorruptedLogEntryWriterFactory", new CorruptedLogEntryWrapper()}), Arguments.of((Object[])new Object[]{"CorruptedLogEntryVersionWriter", new CorruptedLogEntryVersionWrapper()}));
    }

    private static class DelegatingLogEntryWriter<T extends WritableChecksumChannel>
    extends LogEntryWriter<T> {
        private final LogEntryWriter<T> delegate;

        DelegatingLogEntryWriter(LogEntryWriter<T> logEntryWriter) {
            super(logEntryWriter.getChannel(), KernelVersion.LATEST);
            this.delegate = logEntryWriter;
        }

        public void writeLogEntryHeader(byte type, WritableChannel channel) throws IOException {
            this.delegate.writeLogEntryHeader(type, channel);
        }

        public void writeStartEntry(long timeWritten, long latestCommittedTxWhenStarted, int previousChecksum, byte[] additionalHeaderData) throws IOException {
            this.delegate.writeStartEntry(timeWritten, latestCommittedTxWhenStarted, previousChecksum, additionalHeaderData);
        }

        public int writeCommitEntry(long transactionId, long timeWritten) throws IOException {
            return this.delegate.writeCommitEntry(transactionId, timeWritten);
        }

        public void serialize(TransactionRepresentation tx) throws IOException {
            this.delegate.serialize(tx);
        }

        public void serialize(CommittedTransactionRepresentation tx) throws IOException {
            this.delegate.serialize(tx);
        }

        public void serialize(Collection<StorageCommand> commands) throws IOException {
            this.delegate.serialize(commands);
        }

        public void serialize(StorageCommand command) throws IOException {
            this.delegate.serialize(command);
        }

        public void writeLegacyCheckPointEntry(LogPosition logPosition) {
            throw new UnsupportedOperationException("This LogEntryWriter doesn't support writing legacy checkpoints");
        }

        public T getChannel() {
            return (T)this.delegate.getChannel();
        }
    }

    private static class BytesCaptureSupplier
    implements Supplier<Byte> {
        private final Supplier<Byte> generator;
        private final List<Byte> capturedBytes = new ArrayList<Byte>();

        BytesCaptureSupplier(Supplier<Byte> generator) {
            this.generator = generator;
        }

        @Override
        public Byte get() {
            Byte data = this.generator.get();
            this.capturedBytes.add(data);
            return data;
        }

        public List<Byte> getCapturedBytes() {
            return this.capturedBytes;
        }
    }

    private static class PositiveLogFilesBasedLogVersionRepository
    implements LogVersionRepository {
        private long version;
        private long checkpointVersion;

        PositiveLogFilesBasedLogVersionRepository(LogFiles logFiles) {
            this.version = logFiles == null ? 0L : logFiles.getLogFile().getHighestLogVersion();
        }

        public long getCurrentLogVersion() {
            return this.version;
        }

        public void setCurrentLogVersion(long version, CursorContext cursorContext) {
            this.version = version;
        }

        public long incrementAndGetVersion(CursorContext cursorContext) {
            ++this.version;
            return this.version;
        }

        public long getCheckpointLogVersion() {
            return this.checkpointVersion;
        }

        public void setCheckpointLogVersion(long version, CursorContext cursorContext) {
            this.checkpointVersion = version;
        }

        public long incrementAndGetCheckpointLogVersion(CursorContext cursorContext) {
            ++this.checkpointVersion;
            return this.checkpointVersion;
        }
    }

    private static class RecoveryMonitor
    implements org.neo4j.kernel.recovery.RecoveryMonitor {
        private final List<Long> recoveredTransactions = new ArrayList<Long>();
        private int numberOfRecoveredTransactions;
        private final AtomicBoolean recoveryRequired = new AtomicBoolean();

        private RecoveryMonitor() {
        }

        public void recoveryRequired(LogPosition recoveryPosition) {
            this.recoveryRequired.set(true);
        }

        public void transactionRecovered(long txId) {
            this.recoveredTransactions.add(txId);
        }

        public void recoveryCompleted(int numberOfRecoveredTransactions, long recoveryTimeInMilliseconds) {
            this.numberOfRecoveredTransactions = numberOfRecoveredTransactions;
        }

        boolean wasRecoveryRequired() {
            return this.recoveryRequired.get();
        }

        int getNumberOfRecoveredTransactions() {
            return this.numberOfRecoveredTransactions;
        }
    }

    private static class CorruptedLogEntryVersionWriter<T extends WritableChecksumChannel>
    extends DelegatingLogEntryWriter<T> {
        CorruptedLogEntryVersionWriter(LogEntryWriter<T> delegate) {
            super(delegate);
        }

        @Override
        public void writeStartEntry(long timeWritten, long latestCommittedTxWhenStarted, int previousChecksum, byte[] additionalHeaderData) throws IOException {
            byte nonExistingLogEntryVersion = (byte)(KernelVersion.LATEST.version() + 10);
            this.channel.put(nonExistingLogEntryVersion).put((byte)1);
            this.channel.putLong(timeWritten).putLong(latestCommittedTxWhenStarted).putInt(previousChecksum).putInt(additionalHeaderData.length).put(additionalHeaderData, additionalHeaderData.length);
        }
    }

    private static class CorruptedLogEntryVersionWrapper
    implements LogEntryWriterWrapper {
        private CorruptedLogEntryVersionWrapper() {
        }

        @Override
        public <T extends WritableChecksumChannel> LogEntryWriter<T> wrap(LogEntryWriter<T> logEntryWriter) {
            return new CorruptedLogEntryVersionWriter<T>(logEntryWriter);
        }
    }

    private static class CorruptedLogEntryWriter<T extends WritableChecksumChannel>
    extends DelegatingLogEntryWriter<T> {
        CorruptedLogEntryWriter(LogEntryWriter<T> writer) {
            super(writer);
        }

        @Override
        public void writeStartEntry(long timeWritten, long latestCommittedTxWhenStarted, int previousChecksum, byte[] additionalHeaderData) throws IOException {
            this.writeLogEntryHeader((byte)1, (WritableChannel)this.channel);
        }
    }

    private static class CorruptedLogEntryWrapper
    implements LogEntryWriterWrapper {
        private CorruptedLogEntryWrapper() {
        }

        @Override
        public <T extends WritableChecksumChannel> LogEntryWriter<T> wrap(LogEntryWriter<T> logEntryWriter) {
            return new CorruptedLogEntryWriter<T>(logEntryWriter);
        }
    }

    private static class StaticLogEntryWriterFactory<T extends WritableChecksumChannel>
    implements LogEntryWriterFactory {
        private final LogEntryWriter<T> logEntryWriter;

        StaticLogEntryWriterFactory(LogEntryWriter<T> logEntryWriter) {
            this.logEntryWriter = logEntryWriter;
        }

        public <T extends WritableChecksumChannel> LogEntryWriter<T> createEntryWriter(T channel) {
            return this.logEntryWriter;
        }

        public <T extends WritableChecksumChannel> LogEntryWriter<T> createEntryWriter(T channel, KernelVersion version) {
            return this.logEntryWriter;
        }
    }

    @FunctionalInterface
    private static interface LogEntryWriterWrapper {
        public <T extends WritableChecksumChannel> LogEntryWriter<T> wrap(LogEntryWriter<T> var1);
    }
}

