/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.common.EntityType;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.kernel.api.TokenReadSession;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.api.KernelAPIParallelStress;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.Race;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;

@DbmsExtension
@ExtendWith(value={RandomExtension.class})
class KernelAPIParallelLabelScanStressIT {
    private static final int N_THREADS = 10;
    private static final int N_NODES = 10000;
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private RandomRule random;
    @Inject
    private Kernel kernel;

    KernelAPIParallelLabelScanStressIT() {
    }

    @Test
    void shouldDoParallelLabelScans() throws Throwable {
        IndexDescriptor nodeLabelIndex;
        int[] labels = new int[3];
        try (KernelTransaction tx2 = this.kernel.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);){
            labels[0] = KernelAPIParallelLabelScanStressIT.createLabeledNodes(tx2, 10000, "LABEL1");
            labels[1] = KernelAPIParallelLabelScanStressIT.createLabeledNodes(tx2, 10000, "LABEL2");
            labels[2] = KernelAPIParallelLabelScanStressIT.createLabeledNodes(tx2, 10000, "LABEL3");
            tx2.commit();
        }
        try (KernelTransaction tx3 = this.kernel.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);){
            nodeLabelIndex = (IndexDescriptor)tx3.schemaRead().index((SchemaDescriptor)SchemaDescriptor.forAnyEntityTokens((EntityType)EntityType.NODE)).next();
            tx3.commit();
        }
        KernelAPIParallelStress.parallelStressInTx(this.kernel, 10, tx -> tx.cursors().allocateNodeLabelIndexCursor(tx.cursorContext()), (read, cursor) -> this.labelScan((Read)read, (NodeLabelIndexCursor)cursor, nodeLabelIndex, labels[this.random.nextInt(labels.length)]));
    }

    private static int createLabeledNodes(KernelTransaction tx, int nNodes, String labelName) throws KernelException {
        int label = tx.tokenWrite().labelCreateForName(labelName, false);
        for (int i = 0; i < nNodes; ++i) {
            long n = tx.dataWrite().nodeCreate();
            tx.dataWrite().nodeAddLabel(n, label);
        }
        return label;
    }

    private Runnable labelScan(Read read, NodeLabelIndexCursor cursor, IndexDescriptor index, int label) {
        return Race.throwing(() -> {
            TokenReadSession tokenReadSession = read.tokenReadSession(index);
            read.nodeLabelScan(tokenReadSession, cursor, IndexQueryConstraints.unconstrained(), new TokenPredicate(label));
            int n = 0;
            while (cursor.next()) {
                ++n;
            }
            Assertions.assertEquals((int)10000, (int)n, (String)"correct number of nodes");
        });
    }
}

