/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.nio.file.Path;
import java.util.concurrent.Callable;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.IndexConfigurationCompletionCompatibility;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.MinimalIndexAccessorCompatibility;
import org.neo4j.kernel.api.schema.SchemaTestUtil;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.rule.PageCacheAndDependenciesRule;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.test.rule.fs.FileSystemRule;
import org.neo4j.test.runner.ParameterizedSuiteRunner;

@RunWith(value=ParameterizedSuiteRunner.class)
@Suite.SuiteClasses(value={IndexConfigurationCompletionCompatibility.class, MinimalIndexAccessorCompatibility.General.class, MinimalIndexAccessorCompatibility.ReadOnly.class})
public abstract class IndexProviderCompatibilityTestSuite {
    protected abstract IndexProvider createIndexProvider(PageCache var1, FileSystemAbstraction var2, Path var3, Config var4);

    protected abstract IndexPrototype indexPrototype();

    public void consistencyCheck(IndexPopulator populator) {
    }

    public void additionalConfig(Config.Builder configBuilder) {
    }

    public static abstract class Compatibility {
        private final PageCacheAndDependenciesRule pageCacheAndDependenciesRule;
        final RandomRule random;
        @Rule
        public RuleChain ruleChain;
        Path graphDbDir;
        protected FileSystemAbstraction fs;
        protected IndexProvider indexProvider;
        private final IndexPrototype incompleteIndexPrototype;
        protected IndexDescriptor descriptor;
        protected TokenNameLookup tokenNameLookup;
        final IndexProviderCompatibilityTestSuite testSuite;
        final JobScheduler jobScheduler;
        final IndexPopulator.PopulationWorkScheduler populationWorkScheduler;
        private final Config config;

        @Before
        public void setup() throws Exception {
            this.fs = this.pageCacheAndDependenciesRule.fileSystem();
            this.graphDbDir = this.pageCacheAndDependenciesRule.directory().homePath();
            PageCache pageCache = this.pageCacheAndDependenciesRule.pageCache();
            this.indexProvider = this.testSuite.createIndexProvider(pageCache, this.fs, this.graphDbDir, this.config);
            this.descriptor = this.indexProvider.completeConfiguration(this.incompleteIndexPrototype.withName("index_17").materialise(17L));
            this.jobScheduler.start();
        }

        @After
        public void tearDown() throws Exception {
            if (this.jobScheduler != null) {
                this.jobScheduler.shutdown();
            }
        }

        public void additionalConfig(Config.Builder configBuilder) {
        }

        Compatibility(IndexProviderCompatibilityTestSuite testSuite, IndexPrototype prototype) {
            this.testSuite = testSuite;
            Config.Builder configBuilder = Config.newBuilder();
            testSuite.additionalConfig(configBuilder);
            this.additionalConfig(configBuilder);
            this.config = configBuilder.build();
            this.incompleteIndexPrototype = prototype;
            this.jobScheduler = JobSchedulerFactory.createInitialisedScheduler();
            this.populationWorkScheduler = new IndexPopulator.PopulationWorkScheduler(){

                public <T> JobHandle<T> schedule(IndexPopulator.JobDescriptionSupplier descriptionSupplier, Callable<T> job) {
                    return jobScheduler.schedule(Group.INDEX_POPULATION_WORK, new JobMonitoringParams(null, null, null), job);
                }
            };
            this.pageCacheAndDependenciesRule = new PageCacheAndDependenciesRule().with((FileSystemRule)new DefaultFileSystemRule()).with(testSuite.getClass());
            this.random = new RandomRule();
            this.ruleChain = RuleChain.outerRule((TestRule)this.pageCacheAndDependenciesRule).around((TestRule)this.random);
            this.tokenNameLookup = SchemaTestUtil.SIMPLE_NAME_LOOKUP;
        }

        void withPopulator(IndexPopulator populator, ThrowingConsumer<IndexPopulator, Exception> runWithPopulator) throws Exception {
            this.withPopulator(populator, runWithPopulator, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void withPopulator(IndexPopulator populator, ThrowingConsumer<IndexPopulator, Exception> runWithPopulator, boolean closeSuccessfully) throws Exception {
            try {
                populator.create();
                runWithPopulator.accept((Object)populator);
                if (closeSuccessfully) {
                    populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL);
                    this.testSuite.consistencyCheck(populator);
                }
            }
            finally {
                populator.close(closeSuccessfully, CursorContext.NULL);
            }
        }
    }
}

