/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.mockito.Mockito;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.DoubleLatch;

public class ControlledPopulationIndexProvider
extends IndexProvider.Adaptor {
    private IndexPopulator mockedPopulator = new IndexPopulator.Adapter();
    private final IndexAccessor mockedWriter = (IndexAccessor)Mockito.mock(IndexAccessor.class);
    private final CountDownLatch writerLatch = new CountDownLatch(1);
    private InternalIndexState initialIndexState = InternalIndexState.POPULATING;
    final AtomicInteger populatorCallCount = new AtomicInteger();
    final AtomicInteger writerCallCount = new AtomicInteger();
    public static final IndexProviderDescriptor PROVIDER_DESCRIPTOR = new IndexProviderDescriptor("controlled-population", "1.0");

    public ControlledPopulationIndexProvider() {
        super(PROVIDER_DESCRIPTOR, IndexDirectoryStructure.NONE);
        this.setInitialIndexState(this.initialIndexState);
        Mockito.when((Object)this.mockedWriter.newValueReader()).thenReturn((Object)ValueIndexReader.EMPTY);
    }

    public DoubleLatch installPopulationJobCompletionLatch() {
        final DoubleLatch populationCompletionLatch = new DoubleLatch();
        this.mockedPopulator = new IndexPopulator.Adapter(){

            public void create() {
                populationCompletionLatch.startAndWaitForAllToStartAndFinish();
                super.create();
            }

            public IndexSample sample(CursorContext cursorContext) {
                return new IndexSample();
            }
        };
        return populationCompletionLatch;
    }

    public void awaitFullyPopulated() {
        DoubleLatch.awaitLatch((CountDownLatch)this.writerLatch);
    }

    public IndexPopulator getPopulator(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, ByteBufferFactory bufferFactory, MemoryTracker memoryTracker, TokenNameLookup tokenNameLookup) {
        this.populatorCallCount.incrementAndGet();
        return this.mockedPopulator;
    }

    public IndexAccessor getOnlineAccessor(IndexDescriptor indexConfig, IndexSamplingConfig samplingConfig, TokenNameLookup tokenNameLookup) {
        this.writerCallCount.incrementAndGet();
        this.writerLatch.countDown();
        return this.mockedWriter;
    }

    public InternalIndexState getInitialState(IndexDescriptor descriptor, CursorContext cursorContext) {
        return this.initialIndexState;
    }

    public void setInitialIndexState(InternalIndexState initialIndexState) {
        this.initialIndexState = initialIndexState;
    }
}

