/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.AnyTokens;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
class IndexDefinitionToStringTest {
    @Inject
    private GraphDatabaseService db;

    IndexDefinitionToStringTest() {
    }

    @BeforeEach
    void setup() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().getIndexes().forEach(IndexDefinition::drop);
            tx.commit();
        }
    }

    @Test
    void testToString() {
        try (Transaction tx = this.db.beginTx();){
            IndexDefinition labelTokenIndex = tx.schema().indexFor(AnyTokens.ANY_LABELS).withName("labelTokenIndex").create();
            IndexDefinition labelProperty = tx.schema().indexFor(Label.label((String)"someLabel")).on("someProperty").withName("labelIndexName").create();
            IndexDefinition labelProperties = tx.schema().indexFor(Label.label((String)"someLabel")).on("someProperty").on("someOtherProperty").withName("labelIndexNames").create();
            IndexDefinition relTypeTokenIndex = tx.schema().indexFor(AnyTokens.ANY_RELATIONSHIP_TYPES).withName("relTypeTokenIndex").create();
            IndexDefinition relTypeProperty = tx.schema().indexFor(RelationshipType.withName((String)"someRelationship")).on("someProperty").withName("relTypeIndexName").create();
            IndexDefinition relTypeProperties = tx.schema().indexFor(RelationshipType.withName((String)"someRelationship")).on("someProperty").on("someOtherProperty").withName("relTypeIndexNames").create();
            this.assertIndexString(labelTokenIndex, "IndexDefinition[label:<any-labels>] (Index( id=%d, name='labelTokenIndex', type='TOKEN LOOKUP', schema=(:<any-labels>), indexProvider='token-lookup-1.0' ))");
            this.assertIndexString(labelProperty, "IndexDefinition[label:someLabel on:someProperty] (Index( id=%d, name='labelIndexName', type='GENERAL BTREE', schema=(:someLabel {someProperty}), indexProvider='native-btree-1.0' ))");
            this.assertIndexString(labelProperties, "IndexDefinition[label:someLabel on:someProperty,someOtherProperty] (Index( id=%d, name='labelIndexNames', type='GENERAL BTREE', schema=(:someLabel {someProperty, someOtherProperty}), indexProvider='native-btree-1.0' ))");
            this.assertIndexString(relTypeTokenIndex, "IndexDefinition[relationship type:<any-types>] (Index( id=%d, name='relTypeTokenIndex', type='TOKEN LOOKUP', schema=-[:<any-types>]-, indexProvider='token-lookup-1.0' ))");
            this.assertIndexString(relTypeProperty, "IndexDefinition[relationship type:someRelationship on:someProperty] (Index( id=%d, name='relTypeIndexName', type='GENERAL BTREE', schema=-[:someRelationship {someProperty}]-, indexProvider='native-btree-1.0' ))");
            this.assertIndexString(relTypeProperties, "IndexDefinition[relationship type:someRelationship on:someProperty,someOtherProperty] (Index( id=%d, name='relTypeIndexNames', type='GENERAL BTREE', schema=-[:someRelationship {someProperty, someOtherProperty}]-, indexProvider='native-btree-1.0' ))");
        }
    }

    private void assertIndexString(IndexDefinition index, String expectedStringFormat) {
        Assertions.assertThat((String)index.toString()).isEqualTo(expectedStringFormat, new Object[]{((IndexDefinitionImpl)index).getIndexReference().getId()});
    }
}

