/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Scan;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestSupport;
import org.neo4j.kernel.impl.newapi.TestUtils;

public abstract class ParallelNodeCursorTestBase<G extends KernelAPIReadTestSupport>
extends KernelAPIReadTestBase<G> {
    private static LongList NODE_IDS;
    private static final int NUMBER_OF_NODES = 128;
    private static final ToLongFunction<NodeCursor> NODE_GET;

    @Override
    public void createTestGraph(GraphDatabaseService graphDb) {
        try (Transaction tx = graphDb.beginTx();){
            LongArrayList list = new LongArrayList(128);
            for (int i = 0; i < 128; ++i) {
                list.add(tx.createNode().getId());
            }
            NODE_IDS = list;
            tx.commit();
        }
    }

    @Test
    void shouldScanASubsetOfNodes() {
        try (NodeCursor nodes = this.cursors.allocateNodeCursor(CursorContext.NULL);){
            Scan scan = this.read.allNodesScan();
            Assertions.assertTrue((boolean)scan.reserveBatch((Cursor)nodes, 3));
            Assertions.assertTrue((boolean)nodes.next());
            Assertions.assertEquals((long)NODE_IDS.get(0), (long)nodes.nodeReference());
            Assertions.assertTrue((boolean)nodes.next());
            Assertions.assertEquals((long)NODE_IDS.get(1), (long)nodes.nodeReference());
            Assertions.assertTrue((boolean)nodes.next());
            Assertions.assertEquals((long)NODE_IDS.get(2), (long)nodes.nodeReference());
            Assertions.assertFalse((boolean)nodes.next());
        }
    }

    @Test
    void shouldHandleSizeHintOverflow() {
        try (NodeCursor nodes = this.cursors.allocateNodeCursor(CursorContext.NULL);){
            Scan scan = this.read.allNodesScan();
            Assertions.assertTrue((boolean)scan.reserveBatch((Cursor)nodes, 256));
            LongArrayList ids = new LongArrayList();
            while (nodes.next()) {
                ids.add(nodes.nodeReference());
            }
            Assertions.assertEquals((Object)NODE_IDS, (Object)ids);
        }
    }

    @Test
    void shouldFailForSizeHintZero() {
        try (NodeCursor nodes = this.cursors.allocateNodeCursor(CursorContext.NULL);){
            Scan scan = this.read.allNodesScan();
            Assertions.assertThrows(IllegalArgumentException.class, () -> scan.reserveBatch((Cursor)nodes, 0));
        }
    }

    @Test
    void shouldScanAllNodesInBatches() {
        LongArrayList ids = new LongArrayList();
        try (NodeCursor nodes = this.cursors.allocateNodeCursor(CursorContext.NULL);){
            Scan scan = this.read.allNodesScan();
            while (scan.reserveBatch((Cursor)nodes, 3)) {
                while (nodes.next()) {
                    ids.add(nodes.nodeReference());
                }
            }
        }
        Assertions.assertEquals((Object)NODE_IDS, (Object)ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldScanAllNodesFromMultipleThreads() throws InterruptedException, ExecutionException {
        ExecutorService service = Executors.newFixedThreadPool(4);
        Scan scan = this.read.allNodesScan();
        CursorFactory cursors = testSupport.kernelToTest().cursors();
        try {
            Future<LongList> future1 = service.submit(TestUtils.singleBatchWorker(scan, () -> cursors.allocateNodeCursor(CursorContext.NULL), NodeCursor::nodeReference, 32));
            Future<LongList> future2 = service.submit(TestUtils.singleBatchWorker(scan, () -> cursors.allocateNodeCursor(CursorContext.NULL), NodeCursor::nodeReference, 32));
            Future<LongList> future3 = service.submit(TestUtils.singleBatchWorker(scan, () -> cursors.allocateNodeCursor(CursorContext.NULL), NodeCursor::nodeReference, 32));
            Future<LongList> future4 = service.submit(TestUtils.singleBatchWorker(scan, () -> cursors.allocateNodeCursor(CursorContext.NULL), NodeCursor::nodeReference, 32));
            LongList ids1 = future1.get();
            LongList ids2 = future2.get();
            LongList ids3 = future3.get();
            LongList ids4 = future4.get();
            TestUtils.assertDistinct(ids1, ids2, ids3, ids4);
            MutableLongList concat = TestUtils.concat(ids1, ids2, ids3, ids4).toSortedList();
            Assertions.assertEquals((Object)NODE_IDS, (Object)concat);
        }
        finally {
            service.shutdown();
            service.awaitTermination(1L, TimeUnit.MINUTES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldScanAllNodesFromMultipleThreadWithBigSizeHints() throws InterruptedException, ExecutionException {
        ExecutorService service = Executors.newFixedThreadPool(4);
        Scan scan = this.read.allNodesScan();
        CursorFactory cursors = testSupport.kernelToTest().cursors();
        try {
            Supplier<NodeCursor> allocateNodeCursor = () -> cursors.allocateNodeCursor(CursorContext.NULL);
            Future<LongList> future1 = service.submit(TestUtils.singleBatchWorker(scan, allocateNodeCursor, NODE_GET, 100));
            Future<LongList> future2 = service.submit(TestUtils.singleBatchWorker(scan, allocateNodeCursor, NODE_GET, 100));
            Future<LongList> future3 = service.submit(TestUtils.singleBatchWorker(scan, allocateNodeCursor, NODE_GET, 100));
            Future<LongList> future4 = service.submit(TestUtils.singleBatchWorker(scan, allocateNodeCursor, NODE_GET, 100));
            LongList ids1 = future1.get();
            LongList ids2 = future2.get();
            LongList ids3 = future3.get();
            LongList ids4 = future4.get();
            TestUtils.assertDistinct(ids1, ids2, ids3, ids4);
            MutableLongList concat = TestUtils.concat(ids1, ids2, ids3, ids4).toSortedList();
            Assertions.assertEquals((Object)NODE_IDS, (Object)concat);
        }
        finally {
            service.shutdown();
            service.awaitTermination(1L, TimeUnit.MINUTES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldScanAllNodesFromRandomlySizedWorkers() throws InterruptedException, ExecutionException {
        ExecutorService service = Executors.newFixedThreadPool(4);
        Scan scan = this.read.allNodesScan();
        CursorFactory cursors = testSupport.kernelToTest().cursors();
        try {
            ArrayList<Future<LongList>> futures = new ArrayList<Future<LongList>>();
            for (int i = 0; i < 10; ++i) {
                futures.add(service.submit(TestUtils.randomBatchWorker(scan, () -> cursors.allocateNodeCursor(CursorContext.NULL), NODE_GET)));
            }
            service.shutdown();
            service.awaitTermination(1L, TimeUnit.MINUTES);
            List<LongList> lists = futures.stream().map(TestUtils::unsafeGet).collect(Collectors.toList());
            TestUtils.assertDistinct(lists);
            MutableLongList concat = TestUtils.concat(lists).toSortedList();
            Assertions.assertEquals((Object)NODE_IDS, (Object)concat);
        }
        finally {
            service.shutdown();
            service.awaitTermination(1L, TimeUnit.MINUTES);
        }
    }

    static {
        NODE_GET = NodeCursor::nodeReference;
    }
}

