/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tracers;

import java.util.Iterator;
import org.assertj.core.api.BooleanAssert;
import org.assertj.core.api.LongAssert;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.junit.jupiter.InjectSoftAssertions;
import org.assertj.core.api.junit.jupiter.SoftAssertionsExtension;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventListener;
import org.neo4j.graphdb.event.TransactionEventListenerAdapter;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@ExtendWith(value={SoftAssertionsExtension.class})
@DbmsExtension
class TransactionTracingIT {
    private static final int ENTITY_COUNT = 1000;
    @Inject
    private GraphDatabaseAPI database;
    @Inject
    private DatabaseManagementService managementService;
    @InjectSoftAssertions
    private SoftAssertions softly;

    TransactionTracingIT() {
    }

    @Test
    void tracePageCacheAccessOnAllNodesAccess() {
        try (Transaction transaction = this.database.beginTx();){
            for (int i = 0; i < 1000; ++i) {
                transaction.createNode();
            }
            transaction.commit();
        }
        transaction = (InternalTransaction)this.database.beginTx();
        try {
            CursorContext cursorContext = transaction.kernelTransaction().cursorContext();
            this.assertZeroCursor(cursorContext);
            ((LongAssert)this.softly.assertThat(Iterables.count((Iterable)transaction.getAllNodes())).as("Number of expected nodes", new Object[0])).isEqualTo(1000L);
            ((LongAssert)this.softly.assertThat(cursorContext.getCursorTracer().pins()).as("Number of cursor pins", new Object[0])).isEqualTo(2L);
            ((LongAssert)this.softly.assertThat(cursorContext.getCursorTracer().unpins()).as("Number of cursor unpins", new Object[0])).isEqualTo(1L);
            ((LongAssert)this.softly.assertThat(cursorContext.getCursorTracer().hits()).as("Number of cursor hits", new Object[0])).isEqualTo(2L);
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void tracePageCacheAccessOnNodeCreation() {
        try (InternalTransaction transaction = (InternalTransaction)this.database.beginTx();){
            CursorContext cursorContext = transaction.kernelTransaction().cursorContext();
            CommitCursorChecker commitCursorChecker = new CommitCursorChecker(cursorContext);
            this.managementService.registerTransactionEventListener(this.database.databaseName(), (TransactionEventListener)commitCursorChecker);
            for (int i = 0; i < 1000; ++i) {
                transaction.createNode();
            }
            this.assertZeroCursor(cursorContext);
            transaction.commit();
            ((BooleanAssert)this.softly.assertThat(commitCursorChecker.isInvoked()).as("Transaction committed", new Object[0])).isTrue();
        }
    }

    @Test
    void tracePageCacheAccessOnAllRelationshipsAccess() {
        try (Transaction transaction = this.database.beginTx();){
            for (int i = 0; i < 1000; ++i) {
                Node source = transaction.createNode();
                source.createRelationshipTo(transaction.createNode(), RelationshipType.withName((String)"connection"));
            }
            transaction.commit();
        }
        transaction = (InternalTransaction)this.database.beginTx();
        try {
            CursorContext cursorContext = transaction.kernelTransaction().cursorContext();
            this.assertZeroCursor(cursorContext);
            ((LongAssert)this.softly.assertThat(Iterables.count((Iterable)transaction.getAllRelationships())).as("Number of expected relationships", new Object[0])).isEqualTo(1000L);
            ((LongAssert)this.softly.assertThat(cursorContext.getCursorTracer().pins()).as("Number of cursor pins", new Object[0])).isEqualTo(5L);
            ((LongAssert)this.softly.assertThat(cursorContext.getCursorTracer().unpins()).as("Number of cursor unpins", new Object[0])).isEqualTo(5L);
            ((LongAssert)this.softly.assertThat(cursorContext.getCursorTracer().hits()).as("Number of cursor hits", new Object[0])).isEqualTo(5L);
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void tracePageCacheAccessOnFindNodes() {
        Label marker = Label.label((String)"marker");
        RelationshipType type = RelationshipType.withName((String)"connection");
        try (Transaction transaction = this.database.beginTx();){
            for (int i = 0; i < 1000; ++i) {
                Node source = transaction.createNode(new Label[]{marker});
                source.createRelationshipTo(transaction.createNode(), type);
            }
            transaction.commit();
        }
        transaction = (InternalTransaction)this.database.beginTx();
        try {
            CursorContext cursorContext = transaction.kernelTransaction().cursorContext();
            this.assertZeroCursor(cursorContext);
            ((LongAssert)this.softly.assertThat(Iterators.count((Iterator)transaction.findNodes(marker))).as("Number of expected nodes", new Object[0])).isEqualTo(1000L);
            ((LongAssert)this.softly.assertThat(cursorContext.getCursorTracer().pins()).as("Number of cursor pins", new Object[0])).isEqualTo(1L);
            ((LongAssert)this.softly.assertThat(cursorContext.getCursorTracer().unpins()).as("Number of cursor unpins", new Object[0])).isEqualTo(1L);
            ((LongAssert)this.softly.assertThat(cursorContext.getCursorTracer().hits()).as("Number of cursor hits", new Object[0])).isEqualTo(1L);
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void tracePageCacheAccessOnFindRelationships() {
        Label marker = Label.label((String)"marker");
        RelationshipType type = RelationshipType.withName((String)"connection");
        try (Transaction transaction = this.database.beginTx();){
            for (int i = 0; i < 1000; ++i) {
                Node source = transaction.createNode(new Label[]{marker});
                source.createRelationshipTo(transaction.createNode(), type);
            }
            transaction.commit();
        }
        transaction = (InternalTransaction)this.database.beginTx();
        try {
            CursorContext cursorContext = transaction.kernelTransaction().cursorContext();
            this.assertZeroCursor(cursorContext);
            ((LongAssert)this.softly.assertThat(Iterators.count((Iterator)transaction.findRelationships(type))).as("Number of expected relationships", new Object[0])).isEqualTo(1000L);
            ((LongAssert)this.softly.assertThat(cursorContext.getCursorTracer().pins()).as("Number of cursor pins", new Object[0])).isEqualTo(1L);
            ((LongAssert)this.softly.assertThat(cursorContext.getCursorTracer().unpins()).as("Number of cursor unpins", new Object[0])).isEqualTo(1L);
            ((LongAssert)this.softly.assertThat(cursorContext.getCursorTracer().hits()).as("Number of cursor hits", new Object[0])).isEqualTo(1L);
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void tracePageCacheAccessOnDetachDelete() throws KernelException {
        long sourceId;
        RelationshipType type = RelationshipType.withName((String)"connection");
        try (Transaction transaction = this.database.beginTx();){
            Node source = transaction.createNode();
            for (int i = 0; i < 10; ++i) {
                source.createRelationshipTo(transaction.createNode(), type);
            }
            sourceId = source.getId();
            transaction.commit();
        }
        transaction = (InternalTransaction)this.database.beginTx();
        try {
            CursorContext cursorContext = transaction.kernelTransaction().cursorContext();
            this.assertZeroCursor(cursorContext);
            transaction.kernelTransaction().dataWrite().nodeDetachDelete(sourceId);
            ((LongAssert)this.softly.assertThat(cursorContext.getCursorTracer().pins()).as("Number of cursor pins", new Object[0])).isEqualTo(14L);
            ((LongAssert)this.softly.assertThat(cursorContext.getCursorTracer().unpins()).as("Number of cursor unpins", new Object[0])).isEqualTo(11L);
            ((LongAssert)this.softly.assertThat(cursorContext.getCursorTracer().hits()).as("Number of cursor hits", new Object[0])).isEqualTo(14L);
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    private void assertZeroCursor(CursorContext cursorContext) {
        ((LongAssert)this.softly.assertThat(cursorContext.getCursorTracer().pins()).as("Number of cursor pins", new Object[0])).isZero();
        ((LongAssert)this.softly.assertThat(cursorContext.getCursorTracer().unpins()).as("Number of cursor unpins", new Object[0])).isZero();
        ((LongAssert)this.softly.assertThat(cursorContext.getCursorTracer().hits()).as("Number of cursor hits", new Object[0])).isZero();
        ((LongAssert)this.softly.assertThat(cursorContext.getCursorTracer().faults()).as("Number of cursor faults", new Object[0])).isZero();
    }

    private class CommitCursorChecker
    extends TransactionEventListenerAdapter<Object> {
        private final CursorContext cursorContext;
        private volatile boolean invoked;

        CommitCursorChecker(CursorContext cursorContext) {
            this.cursorContext = cursorContext;
        }

        public boolean isInvoked() {
            return this.invoked;
        }

        public void afterCommit(TransactionData data, Object state, GraphDatabaseService databaseService) {
            ((LongAssert)TransactionTracingIT.this.softly.assertThat(this.cursorContext.getCursorTracer().pins()).as("Number of cursor pins", new Object[0])).isEqualTo(1003L);
            ((LongAssert)TransactionTracingIT.this.softly.assertThat(this.cursorContext.getCursorTracer().unpins()).as("Number of cursor unpins", new Object[0])).isEqualTo(1003L);
            ((LongAssert)TransactionTracingIT.this.softly.assertThat(this.cursorContext.getCursorTracer().hits()).as("Number of cursor hits", new Object[0])).isEqualTo(1001L);
            ((LongAssert)TransactionTracingIT.this.softly.assertThat(this.cursorContext.getCursorTracer().faults()).as("Number of cursor faults", new Object[0])).isEqualTo(2L);
            this.invoked = true;
        }
    }
}

