/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.schema;

import java.util.Iterator;
import org.assertj.core.util.Streams;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.internal.recordstorage.SchemaRuleAccess;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class DropBrokenUniquenessConstraintIT {
    private final Label label = Label.label((String)"Label");
    private final String key = "key";
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private RecordStorageEngine storageEngine;
    private long initialConstraintCount;
    private long initialIndexCount;

    DropBrokenUniquenessConstraintIT() {
    }

    @BeforeEach
    void getInitialCounts() {
        try (Transaction tx = this.db.beginTx();){
            this.initialConstraintCount = Streams.stream((Iterable)tx.schema().getConstraints()).count();
            this.initialIndexCount = Streams.stream((Iterable)tx.schema().getIndexes()).count();
        }
    }

    @AfterEach
    void assertNoAdditionalConstraintsOrIndexes() {
        try (Transaction tx = this.db.beginTx();){
            Assertions.assertEquals((long)this.initialConstraintCount, (long)Streams.stream((Iterable)tx.schema().getConstraints()).count());
            Assertions.assertEquals((long)this.initialIndexCount, (long)Streams.stream((Iterable)tx.schema().getIndexes()).count());
        }
    }

    @Test
    void shouldDropUniquenessConstraintWithBackingIndexNotInUse() {
        String backingIndexName;
        try (Transaction tx = this.db.beginTx();){
            tx.schema().constraintFor(this.label).assertPropertyIsUnique("key").create();
            backingIndexName = ((IndexDefinition)Iterators.single(tx.schema().getIndexes(this.label).iterator())).getName();
            tx.commit();
        }
        SchemaRuleAccess schemaRules = this.storageEngine.testAccessSchemaRules();
        schemaRules.deleteSchemaRule((SchemaRule)schemaRules.indexGetForName(backingIndexName, CursorContext.NULL), CursorContext.NULL);
        this.storageEngine.loadSchemaCache();
        try (Transaction tx = this.db.beginTx();){
            ((ConstraintDefinition)Iterators.single(tx.schema().getConstraints(this.label).iterator())).drop();
            tx.commit();
        }
    }

    @Test
    void shouldDropUniquenessConstraintWithBackingIndexHavingNoOwner() throws KernelException {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().constraintFor(this.label).assertPropertyIsUnique("key").create();
            tx.commit();
        }
        SchemaRuleAccess schemaRules = this.storageEngine.testAccessSchemaRules();
        this.writeSchemaRulesWithoutConstraint(schemaRules);
        this.storageEngine.loadSchemaCache();
        try (Transaction tx = this.db.beginTx();){
            ((ConstraintDefinition)Iterators.single(tx.schema().getConstraints(this.label).iterator())).drop();
            tx.commit();
        }
    }

    @Test
    void shouldDropUniquenessConstraintWhereConstraintRecordIsMissing() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().constraintFor(this.label).assertPropertyIsUnique("key").create();
            tx.commit();
        }
        SchemaRuleAccess schemaRules = this.storageEngine.testAccessSchemaRules();
        schemaRules.constraintsGetAllIgnoreMalformed(CursorContext.NULL).forEachRemaining(rule -> schemaRules.deleteSchemaRule((SchemaRule)rule, CursorContext.NULL));
        this.storageEngine.loadSchemaCache();
        try (Transaction tx = this.db.beginTx();){
            tx.schema().getConstraints(this.label).forEach(ConstraintDefinition::drop);
            tx.schema().getIndexes(this.label).forEach(IndexDefinition::drop);
            tx.commit();
        }
    }

    @Test
    void shouldDropUniquenessConstraintWhereConstraintRecordIsMissingAndIndexHasNoOwner() throws KernelException {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().constraintFor(this.label).assertPropertyIsUnique("key").create();
            tx.commit();
        }
        SchemaRuleAccess schemaRules = this.storageEngine.testAccessSchemaRules();
        schemaRules.constraintsGetAllIgnoreMalformed(CursorContext.NULL).forEachRemaining(rule -> schemaRules.deleteSchemaRule((SchemaRule)rule, CursorContext.NULL));
        this.writeSchemaRulesWithoutConstraint(schemaRules);
        this.storageEngine.loadSchemaCache();
        try (Transaction tx = this.db.beginTx();){
            tx.schema().getConstraints(this.label).forEach(ConstraintDefinition::drop);
            tx.schema().getIndexes(this.label).forEach(IndexDefinition::drop);
            tx.commit();
        }
    }

    private void writeSchemaRulesWithoutConstraint(SchemaRuleAccess schemaRules) throws KernelException {
        for (IndexDescriptor rule : Iterators.loop((Iterator)schemaRules.indexesGetAll(CursorContext.NULL))) {
            schemaRules.writeSchemaRule((SchemaRule)rule, CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
    }
}

