/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension(configurationCallback="configure")
class SchemaLoggingIT {
    private static final String CREATION_FINISHED = "Index creation finished for index [%s].";
    private final AssertableLogProvider logProvider = new AssertableLogProvider();
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private IndexProviderMap indexProviderMap;

    SchemaLoggingIT() {
    }

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.setInternalLogProvider((LogProvider)this.logProvider);
    }

    @Test
    void shouldLogUserReadableLabelAndPropertyNames() {
        String labelName = "User";
        String property = "name";
        long indexId = SchemaLoggingIT.createIndex(this.db, labelName, property);
        IndexProvider defaultProvider = this.indexProviderMap.getDefaultProvider();
        IndexProviderDescriptor providerDescriptor = defaultProvider.getProviderDescriptor();
        String indexName = "Index( id=" + indexId + ", name='index_a908f819', type='GENERAL BTREE', schema=(:User {name}), indexProvider='" + providerDescriptor.name() + "' )";
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).forLevel(AssertableLogProvider.Level.INFO).containsMessageWithArguments("Index population started: [%s]", new Object[]{indexName}).containsMessageWithArguments(CREATION_FINISHED, new Object[]{indexName});
    }

    private static long createIndex(GraphDatabaseAPI db, String labelName, String property) {
        long indexId;
        try (Transaction tx = db.beginTx();){
            IndexDefinition indexDefinition = tx.schema().indexFor(Label.label((String)labelName)).on(property).create();
            indexId = ((IndexDefinitionImpl)indexDefinition).getIndexReference().getId();
            tx.commit();
        }
        tx = db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        return indexId;
    }
}

