/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.UncloseableDelegatingFileSystemAbstraction;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.api.index.ControlledPopulationIndexProvider;
import org.neo4j.kernel.impl.api.index.SchemaIndexTestHelper;
import org.neo4j.kernel.impl.index.schema.TokenIndexProviderFactory;
import org.neo4j.test.DoubleLatch;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;

@EphemeralTestDirectoryExtension
class IndexRestartIT {
    @Inject
    private FileSystemAbstraction fs;
    private GraphDatabaseService db;
    private TestDatabaseManagementServiceBuilder factory;
    private final ControlledPopulationIndexProvider provider = new ControlledPopulationIndexProvider();
    private final Label myLabel = Label.label((String)"MyLabel");
    private DatabaseManagementService managementService;

    IndexRestartIT() {
    }

    @BeforeEach
    void before() {
        this.factory = new TestDatabaseManagementServiceBuilder();
        this.factory.setFileSystem((FileSystemAbstraction)new UncloseableDelegatingFileSystemAbstraction(this.fs));
        this.factory.setExtensions(Arrays.asList(SchemaIndexTestHelper.singleInstanceIndexProviderFactory((String)"test", (IndexProvider)this.provider), new TokenIndexProviderFactory()));
    }

    @AfterEach
    void after() {
        this.managementService.shutdown();
    }

    @Test
    void shouldBeAbleToDropIndexWhileItIsPopulating() {
        this.startDb();
        DoubleLatch populationCompletionLatch = this.provider.installPopulationJobCompletionLatch();
        IndexDefinition index = this.createIndex();
        populationCompletionLatch.waitForAllToStart();
        this.dropIndex(index, populationCompletionLatch);
        try (Transaction transaction = this.db.beginTx();){
            Assertions.assertThat(this.getIndexes(transaction, this.myLabel)).isEmpty();
            NotFoundException e = (NotFoundException)org.junit.jupiter.api.Assertions.assertThrows(NotFoundException.class, () -> this.indexState(transaction, index));
            Assertions.assertThat((Throwable)e).hasMessageContaining(this.myLabel.name());
        }
    }

    @Test
    void shouldHandleRestartOfOnlineIndex() {
        this.startDb();
        this.createIndex();
        this.provider.awaitFullyPopulated();
        this.stopDb();
        this.provider.setInitialIndexState(InternalIndexState.ONLINE);
        this.startDb();
        try (Transaction transaction = this.db.beginTx();){
            Iterable<IndexDefinition> indexes = this.getIndexes(transaction, this.myLabel);
            for (IndexDefinition definition : indexes) {
                Assertions.assertThat((Comparable)this.indexState(transaction, definition)).isEqualTo((Object)Schema.IndexState.ONLINE);
            }
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.provider.populatorCallCount.get());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)this.provider.writerCallCount.get());
    }

    @Test
    void shouldHandleRestartIndexThatHasNotComeOnlineYet() {
        this.startDb();
        this.createIndex();
        this.stopDb();
        this.provider.setInitialIndexState(InternalIndexState.POPULATING);
        this.startDb();
        try (Transaction transaction = this.db.beginTx();){
            Iterable<IndexDefinition> indexes = this.getIndexes(transaction, this.myLabel);
            for (IndexDefinition definition : indexes) {
                Assertions.assertThat((Comparable)this.indexState(transaction, definition)).isNotEqualTo((Object)Schema.IndexState.FAILED);
            }
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)this.provider.populatorCallCount.get());
    }

    private IndexDefinition createIndex() {
        try (Transaction tx = this.db.beginTx();){
            IndexDefinition index = tx.schema().indexFor(this.myLabel).on("number_of_bananas_owned").create();
            tx.commit();
            IndexDefinition indexDefinition = index;
            return indexDefinition;
        }
    }

    private void dropIndex(IndexDefinition index, DoubleLatch populationCompletionLatch) {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().getIndexByName(index.getName()).drop();
            populationCompletionLatch.finish();
            tx.commit();
        }
    }

    private void startDb() {
        if (this.managementService != null) {
            this.managementService.shutdown();
        }
        this.managementService = this.factory.impermanent().noOpSystemGraphInitializer().setConfig(GraphDatabaseSettings.default_schema_provider, (Object)this.provider.getProviderDescriptor().name()).build();
        this.db = this.managementService.database("neo4j");
    }

    private void stopDb() {
        if (this.managementService != null) {
            this.managementService.shutdown();
        }
    }

    private Iterable<IndexDefinition> getIndexes(Transaction transaction, Label label) {
        return transaction.schema().getIndexes(label);
    }

    private Schema.IndexState indexState(Transaction transaction, IndexDefinition index) {
        return transaction.schema().getIndexState(index);
    }
}

