/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.test.DoubleLatch;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class NodeGetUniqueFromIndexSeekIT
extends KernelIntegrationTest {
    private int labelId;
    private int propertyId1;
    private int propertyId2;

    NodeGetUniqueFromIndexSeekIT() {
    }

    @BeforeEach
    void createKeys() throws Exception {
        TokenWrite tokenWrite = this.tokenWriteInNewTransaction();
        this.labelId = tokenWrite.labelGetOrCreateForName("Person");
        this.propertyId1 = tokenWrite.propertyKeyGetOrCreateForName("foo");
        this.propertyId2 = tokenWrite.propertyKeyGetOrCreateForName("bar");
        this.commit();
    }

    @Test
    void shouldFindMatchingNode() throws Exception {
        IndexDescriptor index = this.createUniquenessConstraint(this.labelId, this.propertyId1);
        Value value = Values.of((Object)"value");
        long nodeId = this.createNodeWithValue(value);
        KernelTransaction transaction = this.newTransaction();
        Read read = transaction.dataRead();
        int propertyId = index.schema().getPropertyIds()[0];
        try (NodeValueIndexCursor cursor = transaction.cursors().allocateNodeValueIndexCursor(transaction.cursorContext(), transaction.memoryTracker());){
            long foundId = read.lockingNodeUniqueIndexSeek(index, cursor, new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)propertyId, (Object)value)});
            Assertions.assertEquals((long)nodeId, (long)foundId, (String)"Created node was not found");
        }
        this.commit();
    }

    @Test
    void shouldNotFindNonMatchingNode() throws Exception {
        IndexDescriptor index = this.createUniquenessConstraint(this.labelId, this.propertyId1);
        Value value = Values.of((Object)"value");
        this.createNodeWithValue(Values.of((Object)("other_" + value)));
        KernelTransaction transaction = this.newTransaction();
        try (NodeValueIndexCursor cursor = transaction.cursors().allocateNodeValueIndexCursor(transaction.cursorContext(), transaction.memoryTracker());){
            long foundId = transaction.dataRead().lockingNodeUniqueIndexSeek(index, cursor, new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)this.propertyId1, (Object)value)});
            Assertions.assertTrue((boolean)NodeGetUniqueFromIndexSeekIT.isNoSuchNode(foundId), (String)"Non-matching created node was found");
        }
        this.commit();
    }

    @Test
    void shouldCompositeFindMatchingNode() throws Exception {
        IndexDescriptor index = this.createUniquenessConstraint(this.labelId, this.propertyId1, this.propertyId2);
        Value value1 = Values.of((Object)"value1");
        Value value2 = Values.of((Object)"value2");
        long nodeId = this.createNodeWithValues(value1, value2);
        KernelTransaction transaction = this.newTransaction();
        try (NodeValueIndexCursor cursor = transaction.cursors().allocateNodeValueIndexCursor(transaction.cursorContext(), transaction.memoryTracker());){
            long foundId = transaction.dataRead().lockingNodeUniqueIndexSeek(index, cursor, new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)this.propertyId1, (Object)value1), PropertyIndexQuery.exact((int)this.propertyId2, (Object)value2)});
            Assertions.assertEquals((long)nodeId, (long)foundId, (String)"Created node was not found");
        }
        this.commit();
    }

    @Test
    void shouldNotCompositeFindNonMatchingNode() throws Exception {
        IndexDescriptor index = this.createUniquenessConstraint(this.labelId, this.propertyId1, this.propertyId2);
        Value value1 = Values.of((Object)"value1");
        Value value2 = Values.of((Object)"value2");
        this.createNodeWithValues(Values.of((Object)("other_" + value1)), Values.of((Object)("other_" + value2)));
        KernelTransaction transaction = this.newTransaction();
        try (NodeValueIndexCursor cursor = transaction.cursors().allocateNodeValueIndexCursor(transaction.cursorContext(), transaction.memoryTracker());){
            long foundId = transaction.dataRead().lockingNodeUniqueIndexSeek(index, cursor, new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)this.propertyId1, (Object)value1), PropertyIndexQuery.exact((int)this.propertyId2, (Object)value2)});
            Assertions.assertTrue((boolean)NodeGetUniqueFromIndexSeekIT.isNoSuchNode(foundId), (String)"Non-matching created node was found");
        }
        this.commit();
    }

    @Test
    void shouldBlockUniqueIndexSeekFromCompetingTransaction() throws Exception {
        DoubleLatch latch = new DoubleLatch();
        IndexDescriptor index = this.createUniquenessConstraint(this.labelId, this.propertyId1);
        Value value = Values.of((Object)"value");
        Write write = this.dataWriteInNewTransaction();
        long nodeId = write.nodeCreate();
        write.nodeAddLabel(nodeId, this.labelId);
        write.nodeSetProperty(nodeId, this.propertyId1, value);
        Runnable runnableForThread2 = () -> {
            latch.waitForAllToStart();
            try (KernelTransaction tx = this.kernel.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);){
                try (NodeValueIndexCursor cursor = tx.cursors().allocateNodeValueIndexCursor(tx.cursorContext(), tx.memoryTracker());){
                    tx.dataRead().lockingNodeUniqueIndexSeek(index, cursor, new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)this.propertyId1, (Object)value)});
                }
                tx.commit();
            }
            catch (KernelException e) {
                throw new RuntimeException(e);
            }
            finally {
                latch.finish();
            }
        };
        Thread thread2 = new Thread(runnableForThread2, "Transaction Thread 2");
        thread2.start();
        latch.startAndWaitForAllToStart();
        while (thread2.getState() != Thread.State.TIMED_WAITING && thread2.getState() != Thread.State.WAITING) {
            Thread.yield();
        }
        this.commit();
        latch.waitForAllToFinish();
    }

    private static boolean isNoSuchNode(long foundId) {
        return -1L == foundId;
    }

    private long createNodeWithValue(Value value) throws KernelException {
        Write write = this.dataWriteInNewTransaction();
        long nodeId = write.nodeCreate();
        write.nodeAddLabel(nodeId, this.labelId);
        write.nodeSetProperty(nodeId, this.propertyId1, value);
        this.commit();
        return nodeId;
    }

    private long createNodeWithValues(Value value1, Value value2) throws KernelException {
        Write write = this.dataWriteInNewTransaction();
        long nodeId = write.nodeCreate();
        write.nodeAddLabel(nodeId, this.labelId);
        write.nodeSetProperty(nodeId, this.propertyId1, value1);
        write.nodeSetProperty(nodeId, this.propertyId2, value2);
        this.commit();
        return nodeId;
    }

    private IndexDescriptor createUniquenessConstraint(int labelId, int ... propertyIds) throws Exception {
        KernelTransaction transaction = this.newTransaction(LoginContext.AUTH_DISABLED);
        LabelSchemaDescriptor schema = SchemaDescriptor.forLabel((int)labelId, (int[])propertyIds);
        ConstraintDescriptor constraint = transaction.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)schema));
        IndexDescriptor index = transaction.schemaRead().indexGetForName(constraint.getName());
        this.commit();
        return index;
    }
}

