/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import org.apache.commons.lang3.exception.ExceptionUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.ExtensionType;
import org.neo4j.kernel.extension.context.ExtensionContext;
import org.neo4j.kernel.impl.coreapi.ProcedureWithException;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;

@DbmsExtension(configurationCallback="configure")
class QueryFailureTransactionIT {
    @Inject
    private GraphDatabaseAPI databaseAPI;

    QueryFailureTransactionIT() {
    }

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.addExtension((ExtensionFactory)new CustomProcedureExtension(ProcedureWithException.class));
    }

    @Test
    void failedQueryExecutionRollbackTransaction() {
        try (Transaction transaction = this.databaseAPI.beginTx();){
            org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> transaction.execute("CREATE (n:evilNode {v:0}) WITH (n) RETURN 1/n.v"));
            this.checkFailToCommit(transaction);
        }
    }

    @Test
    void failedQueryExecutionRollbackTransactionAndAllowUserRollback() {
        try (Transaction transaction = this.databaseAPI.beginTx();){
            org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> transaction.execute("CREATE (n:evilNode {v:0}) WITH (n) RETURN 1/n.v"));
            transaction.rollback();
            this.checkFailToCommit(transaction);
        }
    }

    @Test
    void incorrectQueryRollbacksTransaction() {
        try (Transaction transaction = this.databaseAPI.beginTx();){
            org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> transaction.execute("rollback everything!"));
            this.checkFailToCommit(transaction);
        }
    }

    @Test
    void rollbackTransactionOnResultException() {
        try (Transaction transaction = this.databaseAPI.beginTx();){
            Result result = transaction.execute("CALL exception.stream.generate()");
            org.junit.jupiter.api.Assertions.assertThrows(QueryExecutionException.class, () -> {
                while (result.hasNext()) {
                    result.next();
                }
            });
            this.checkFailToCommit(transaction);
        }
    }

    private void checkFailToCommit(Transaction transaction) {
        TransactionFailureException e = (TransactionFailureException)org.junit.jupiter.api.Assertions.assertThrows(TransactionFailureException.class, () -> ((Transaction)transaction).commit());
        Assertions.assertThat((Throwable)ExceptionUtils.getRootCause((Throwable)e)).isInstanceOf(NotInTransactionException.class);
    }

    private static class CustomProcedureExtension
    extends ExtensionFactory<Dependencies> {
        private final Class<?> procedureClass;

        CustomProcedureExtension(Class<?> procedureClass) {
            super(ExtensionType.DATABASE, "customProcedureRegistration");
            this.procedureClass = procedureClass;
        }

        public Lifecycle newInstance(ExtensionContext context, final Dependencies dependencies) {
            if ("neo4j".equals(dependencies.database().getNamedDatabaseId().name())) {
                return new LifecycleAdapter(){

                    public void start() throws Exception {
                        dependencies.procedures().registerProcedure(procedureClass);
                    }
                };
            }
            return new LifecycleAdapter();
        }

        static interface Dependencies {
            public GlobalProcedures procedures();

            public Database database();
        }
    }
}

