/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.neo4j.common.ProgressReporter;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.batchimport.BatchImporterFactory;
import org.neo4j.internal.batchimport.IndexImporterFactory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.format.standard.StandardV4_0;
import org.neo4j.kernel.impl.storemigration.RecordStorageMigrator;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.NullLogService;
import org.neo4j.logging.internal.SimpleLogService;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.scheduler.ThreadPoolJobScheduler;

@PageCacheExtension
@Neo4jLayoutExtension
@ExtendWith(value={RandomExtension.class})
class StoreMigratorTest {
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private FileSystemAbstraction fileSystem;
    @Inject
    private PageCache pageCache;
    @Inject
    private Neo4jLayout neo4jLayout;
    @Inject
    private DatabaseLayout databaseLayout;
    @Inject
    private RandomRule random;
    private JobScheduler jobScheduler;
    private final BatchImporterFactory batchImporterFactory = BatchImporterFactory.withHighestPriority();

    StoreMigratorTest() {
    }

    @BeforeEach
    void setUp() {
        this.jobScheduler = new ThreadPoolJobScheduler();
    }

    @AfterEach
    void tearDown() throws Exception {
        this.jobScheduler.close();
    }

    @Test
    void shouldExtractTransactionInformationFromMetaDataStore() throws Exception {
        long txId = 42L;
        int checksum = 123456789;
        long timestamp = 919191919191919191L;
        TransactionId expected = new TransactionId(txId, checksum, timestamp);
        Path neoStore = this.databaseLayout.metadataStore();
        Files.createFile(neoStore, new FileAttribute[0]);
        Config config = (Config)Mockito.mock(Config.class);
        LogService logService = (LogService)Mockito.mock(LogService.class);
        MetaDataStore.setRecord((PageCache)this.pageCache, (Path)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LAST_TRANSACTION_ID, (long)txId, (String)this.databaseLayout.getDatabaseName(), (CursorContext)CursorContext.NULL);
        MetaDataStore.setRecord((PageCache)this.pageCache, (Path)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LAST_TRANSACTION_CHECKSUM, (long)checksum, (String)this.databaseLayout.getDatabaseName(), (CursorContext)CursorContext.NULL);
        MetaDataStore.setRecord((PageCache)this.pageCache, (Path)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LAST_TRANSACTION_COMMIT_TIMESTAMP, (long)timestamp, (String)this.databaseLayout.getDatabaseName(), (CursorContext)CursorContext.NULL);
        RecordStorageMigrator migrator = new RecordStorageMigrator(this.fileSystem, this.pageCache, config, logService, this.jobScheduler, PageCacheTracer.NULL, this.batchImporterFactory, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        TransactionId actual = migrator.extractTransactionIdInformation(neoStore, txId, this.databaseLayout, CursorContext.NULL);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    void shouldGenerateTransactionInformationWhenLogsNotPresent() throws Exception {
        long txId = 42L;
        Path neoStore = this.databaseLayout.metadataStore();
        Files.createFile(neoStore, new FileAttribute[0]);
        Config config = (Config)Mockito.mock(Config.class);
        SimpleLogService logService = new SimpleLogService((LogProvider)NullLogProvider.getInstance(), (LogProvider)NullLogProvider.getInstance());
        Assertions.assertEquals((long)-1L, (long)MetaDataStore.getRecord((PageCache)this.pageCache, (Path)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LAST_TRANSACTION_ID, (String)this.databaseLayout.getDatabaseName(), (CursorContext)CursorContext.NULL));
        Assertions.assertEquals((long)-1L, (long)MetaDataStore.getRecord((PageCache)this.pageCache, (Path)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LAST_TRANSACTION_CHECKSUM, (String)this.databaseLayout.getDatabaseName(), (CursorContext)CursorContext.NULL));
        Assertions.assertEquals((long)-1L, (long)MetaDataStore.getRecord((PageCache)this.pageCache, (Path)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LAST_TRANSACTION_COMMIT_TIMESTAMP, (String)this.databaseLayout.getDatabaseName(), (CursorContext)CursorContext.NULL));
        RecordStorageMigrator migrator = new RecordStorageMigrator(this.fileSystem, this.pageCache, config, (LogService)logService, this.jobScheduler, PageCacheTracer.NULL, this.batchImporterFactory, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        TransactionId actual = migrator.extractTransactionIdInformation(neoStore, txId, this.databaseLayout, CursorContext.NULL);
        Assertions.assertEquals((long)txId, (long)actual.transactionId());
        Assertions.assertEquals((int)1, (int)actual.checksum());
        Assertions.assertEquals((long)1L, (long)actual.commitTimestamp());
    }

    @Test
    void extractTransactionInformationFromLogsInCustomAbsoluteLocation() throws Exception {
        Path customLogLocation = this.testDirectory.directory("customLogLocation");
        this.extractTransactionalInformationFromLogs(customLogLocation.toAbsolutePath());
    }

    @Test
    void shouldGenerateTransactionInformationWhenLogsAreEmpty() throws Exception {
        long txId = 1L;
        Path neoStore = this.databaseLayout.metadataStore();
        Files.createFile(neoStore, new FileAttribute[0]);
        Config config = (Config)Mockito.mock(Config.class);
        SimpleLogService logService = new SimpleLogService((LogProvider)NullLogProvider.getInstance(), (LogProvider)NullLogProvider.getInstance());
        Assertions.assertEquals((long)-1L, (long)MetaDataStore.getRecord((PageCache)this.pageCache, (Path)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LAST_TRANSACTION_ID, (String)this.databaseLayout.getDatabaseName(), (CursorContext)CursorContext.NULL));
        Assertions.assertEquals((long)-1L, (long)MetaDataStore.getRecord((PageCache)this.pageCache, (Path)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LAST_TRANSACTION_CHECKSUM, (String)this.databaseLayout.getDatabaseName(), (CursorContext)CursorContext.NULL));
        Assertions.assertEquals((long)-1L, (long)MetaDataStore.getRecord((PageCache)this.pageCache, (Path)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LAST_TRANSACTION_COMMIT_TIMESTAMP, (String)this.databaseLayout.getDatabaseName(), (CursorContext)CursorContext.NULL));
        RecordStorageMigrator migrator = new RecordStorageMigrator(this.fileSystem, this.pageCache, config, (LogService)logService, this.jobScheduler, PageCacheTracer.NULL, this.batchImporterFactory, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        TransactionId actual = migrator.extractTransactionIdInformation(neoStore, txId, this.databaseLayout, CursorContext.NULL);
        Assertions.assertEquals((long)txId, (long)actual.transactionId());
        Assertions.assertEquals((int)-559063315, (int)actual.checksum());
        Assertions.assertEquals((long)0L, (long)actual.commitTimestamp());
    }

    @Test
    void writeAndReadLastTxInformation() throws IOException {
        RecordStorageMigrator migrator = this.newStoreMigrator();
        TransactionId writtenTxId = new TransactionId(this.random.nextLong(), this.random.nextInt(), this.random.nextLong());
        migrator.writeLastTxInformation(this.databaseLayout, writtenTxId);
        TransactionId readTxId = migrator.readLastTxInformation(this.databaseLayout);
        Assertions.assertEquals((Object)writtenTxId, (Object)readTxId);
    }

    @Test
    void writeAndReadLastTxLogPosition() throws IOException {
        RecordStorageMigrator migrator = this.newStoreMigrator();
        LogPosition writtenLogPosition = new LogPosition(this.random.nextLong(), this.random.nextLong());
        migrator.writeLastTxLogPosition(this.databaseLayout, writtenLogPosition);
        LogPosition readLogPosition = migrator.readLastTxLogPosition(this.databaseLayout);
        Assertions.assertEquals((Object)writtenLogPosition, (Object)readLogPosition);
    }

    @Test
    void shouldNotMigrateFilesForVersionsWithSameCapability() throws Exception {
        RecordStorageMigrator migrator = this.newStoreMigrator();
        DatabaseLayout dbLayout = this.databaseLayout;
        Path neoStore = dbLayout.metadataStore();
        Files.createFile(neoStore, new FileAttribute[0]);
        MyProgressReporter progressReporter = new MyProgressReporter();
        DatabaseLayout migrationLayout = this.neo4jLayout.databaseLayout("migrationDir");
        this.fileSystem.mkdirs(migrationLayout.databaseDirectory());
        migrator.migrate(dbLayout, migrationLayout, (ProgressReporter)progressReporter, StandardV4_0.STORE_VERSION, StandardV4_0.STORE_VERSION, IndexImporterFactory.EMPTY);
        Assertions.assertFalse((boolean)progressReporter.started);
    }

    private void extractTransactionalInformationFromLogs(Path customLogsLocation) throws IOException {
        Config config = Config.defaults((Setting)GraphDatabaseSettings.transaction_logs_root_path, (Object)customLogsLocation);
        SimpleLogService logService = new SimpleLogService((LogProvider)NullLogProvider.getInstance(), (LogProvider)NullLogProvider.getInstance());
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.databaseLayout).setConfig(GraphDatabaseSettings.transaction_logs_root_path, (Object)customLogsLocation).build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        StorageEngineFactory storageEngineFactory = (StorageEngineFactory)database.getDependencyResolver().resolveDependency(StorageEngineFactory.class);
        for (int i = 0; i < 10; ++i) {
            try (Transaction transaction = database.beginTx();){
                transaction.createNode();
                transaction.commit();
                continue;
            }
        }
        DatabaseLayout databaseLayout = database.databaseLayout();
        Path neoStore = databaseLayout.metadataStore();
        managementService.shutdown();
        MetaDataStore.setRecord((PageCache)this.pageCache, (Path)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LAST_CLOSED_TRANSACTION_LOG_VERSION, (long)-1L, (String)databaseLayout.getDatabaseName(), (CursorContext)CursorContext.NULL);
        RecordStorageMigrator migrator = new RecordStorageMigrator(this.fileSystem, this.pageCache, config, (LogService)logService, this.jobScheduler, PageCacheTracer.NULL, this.batchImporterFactory, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        LogPosition logPosition = migrator.extractTransactionLogPosition(neoStore, databaseLayout, 100L, CursorContext.NULL);
        LogFiles logFiles = LogFilesBuilder.activeFilesBuilder((DatabaseLayout)databaseLayout, (FileSystemAbstraction)this.fileSystem, (PageCache)this.pageCache).withConfig(config).withCommandReaderFactory(storageEngineFactory.commandReaderFactory()).build();
        Assertions.assertEquals((long)0L, (long)logPosition.getLogVersion());
        Assertions.assertEquals((long)Files.size(logFiles.getLogFile().getHighestLogFile()), (long)logPosition.getByteOffset());
    }

    private RecordStorageMigrator newStoreMigrator() {
        return new RecordStorageMigrator(this.fileSystem, this.pageCache, Config.defaults(), (LogService)NullLogService.getInstance(), this.jobScheduler, PageCacheTracer.NULL, this.batchImporterFactory, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    private static class MyProgressReporter
    implements ProgressReporter {
        public boolean started;

        private MyProgressReporter() {
        }

        public void start(long max) {
            this.started = true;
        }

        public void progress(long add) {
        }

        public void completed() {
        }
    }
}

