/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tracers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.RecordStorageCommandCreationContext;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.internal.recordstorage.RecordStorageReader;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceLocker;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandCreationContext;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;

@DbmsExtension(configurationCallback="configure")
public class CommitProcessTracingIT {
    @Inject
    private GraphDatabaseAPI database;
    @Inject
    private TransactionCommitProcess commitProcess;
    @Inject
    private RecordStorageEngine storageEngine;

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseInternalSettings.additional_lock_verification, (Object)false);
    }

    @Test
    void tracePageCacheAccessOnCommandCreation() throws KernelException {
        long sourceId;
        try (Transaction transaction = this.database.beginTx();){
            sourceId = transaction.createNode(new Label[]{Label.label((String)"a")}).getId();
            transaction.commit();
        }
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
        try (CursorContext cursorContext = new CursorContext(pageCacheTracer.createPageCursorTracer("tracePageCacheAccessOnCommandCreation"));
             RecordStorageReader reader = this.storageEngine.newReader();){
            this.assertZeroCursor(cursorContext);
            try (RecordStorageCommandCreationContext context = this.storageEngine.newCommandCreationContext((MemoryTracker)EmptyMemoryTracker.INSTANCE);){
                context.initialize(cursorContext);
                ArrayList commands = new ArrayList();
                TxState txState = new TxState();
                txState.nodeDoAddLabel(1L, sourceId);
                this.storageEngine.createCommands(commands, (ReadableTransactionState)txState, (StorageReader)reader, (CommandCreationContext)context, ResourceLocker.IGNORE, LockTracer.NONE, 0L, TxStateVisitor.NO_DECORATION, cursorContext, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            }
            this.assertCursor(cursorContext, 2);
        }
    }

    @Test
    void tracePageCacheAccessOnEmptyTransactionApply() throws TransactionFailureException {
        PhysicalTransactionRepresentation transaction = new PhysicalTransactionRepresentation(Collections.emptyList(), ArrayUtils.EMPTY_BYTE_ARRAY, 0L, 0L, 0L, 0, AuthSubject.ANONYMOUS);
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
        try (CursorContext cursorContext = new CursorContext(pageCacheTracer.createPageCursorTracer("tracePageCacheAccessOnEmptyTransactionApply"));){
            this.assertZeroCursor(cursorContext);
            this.commitProcess.commit(new TransactionToApply((TransactionRepresentation)transaction, cursorContext), CommitEvent.NULL, TransactionApplicationMode.EXTERNAL);
            this.assertCursor(cursorContext, 2);
        }
    }

    @Test
    void tracePageCacheAccessOnTransactionApply() throws TransactionFailureException {
        PhysicalTransactionRepresentation transaction = new PhysicalTransactionRepresentation(List.of(new Command.NodeCountsCommand(1, 2L)), ArrayUtils.EMPTY_BYTE_ARRAY, 0L, 0L, 0L, 0, AuthSubject.ANONYMOUS);
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
        try (CursorContext cursorContext = new CursorContext(pageCacheTracer.createPageCursorTracer("tracePageCacheAccessOnTransactionApply"));){
            this.assertZeroCursor(cursorContext);
            this.commitProcess.commit(new TransactionToApply((TransactionRepresentation)transaction, cursorContext), CommitEvent.NULL, TransactionApplicationMode.EXTERNAL);
            this.assertCursor(cursorContext, 3);
        }
    }

    private void assertCursor(CursorContext cursorContext, int expected) {
        PageCursorTracer cursorTracer = cursorContext.getCursorTracer();
        Assertions.assertThat((long)cursorTracer.pins()).isEqualTo((long)expected);
        Assertions.assertThat((long)cursorTracer.unpins()).isEqualTo((long)expected);
        Assertions.assertThat((long)cursorTracer.hits()).isEqualTo((long)expected);
    }

    private void assertZeroCursor(CursorContext cursorContext) {
        PageCursorTracer cursorTracer = cursorContext.getCursorTracer();
        Assertions.assertThat((long)cursorTracer.pins()).isZero();
        Assertions.assertThat((long)cursorTracer.unpins()).isZero();
        Assertions.assertThat((long)cursorTracer.hits()).isZero();
    }
}

