/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.io.ByteUnit;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.monitoring.Monitors;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;

@DbmsExtension(configurationCallback="configure")
class BlockBasedIndexPopulationMemoryUsageIT {
    private static final long TEST_BLOCK_SIZE = ByteUnit.kibiBytes((long)64L);
    private static final String[] KEYS = new String[]{"key1", "key2", "key3", "key4"};
    private static final Label[] LABELS = new Label[]{Label.label((String)"Label1"), Label.label((String)"Label2"), Label.label((String)"Label3"), Label.label((String)"Label4")};
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private Monitors monitors;

    BlockBasedIndexPopulationMemoryUsageIT() {
    }

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseInternalSettings.index_populator_block_size, (Object)TEST_BLOCK_SIZE);
    }

    @Test
    void shouldKeepMemoryConsumptionLowDuringPopulation() throws InterruptedException {
        IndexPopulationMemoryUsageMonitor monitor = new IndexPopulationMemoryUsageMonitor();
        this.monitors.addMonitorListener((Object)monitor, new String[0]);
        this.someData();
        this.createLotsOfIndexesInOneTransaction();
        monitor.called.await();
        long targetMemoryConsumption = TEST_BLOCK_SIZE * 9L * 8L;
        Assertions.assertThat((long)monitor.peakDirectMemoryUsage).isLessThan(targetMemoryConsumption * 2L + 1L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createLotsOfIndexesInOneTransaction() {
        try (Transaction tx = this.db.beginTx();){
            Schema schema = tx.schema();
            for (Label label : LABELS) {
                for (String key : KEYS) {
                    schema.indexFor(label).on(key).create();
                }
            }
            tx.commit();
        }
        while (true) {
            try {
                tx = this.db.beginTx();
                try {
                    tx.schema().awaitIndexesOnline(1L, TimeUnit.SECONDS);
                    return;
                }
                finally {
                    if (tx != null) {
                        tx.close();
                    }
                }
            }
            catch (IllegalStateException e) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e1) {
                    return;
                }
            }
        }
    }

    private void someData() throws InterruptedException {
        int threads = Runtime.getRuntime().availableProcessors();
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        for (int i = 0; i < threads; ++i) {
            executor.submit(() -> {
                for (int t = 0; t < 100; ++t) {
                    try (Transaction tx = this.db.beginTx();){
                        for (int n = 0; n < 100; ++n) {
                            Node node = tx.createNode(LABELS);
                            for (String key : KEYS) {
                                node.setProperty(key, (Object)String.format("some value %d", n));
                            }
                        }
                        tx.commit();
                        continue;
                    }
                }
            });
        }
        executor.shutdown();
        while (!executor.awaitTermination(1L, TimeUnit.SECONDS)) {
        }
    }

    private static class IndexPopulationMemoryUsageMonitor
    extends IndexingService.MonitorAdapter {
        private volatile long peakDirectMemoryUsage;
        private final CountDownLatch called = new CountDownLatch(1);

        private IndexPopulationMemoryUsageMonitor() {
        }

        public void populationJobCompleted(long peakDirectMemoryUsage) {
            this.peakDirectMemoryUsage = peakDirectMemoryUsage;
            this.called.countDown();
        }
    }
}

