/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.WriteOperationsNotAllowedException;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.UncloseableDelegatingFileSystemAbstraction;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.DbRepresentation;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@EphemeralTestDirectoryExtension
class TestReadOnlyNeo4j {
    @Inject
    private EphemeralFileSystemAbstraction fs;
    @Inject
    private TestDirectory testDirectory;
    private DatabaseManagementService managementService;

    TestReadOnlyNeo4j() {
    }

    @AfterEach
    void tearDown() {
        if (this.managementService != null) {
            this.managementService.shutdown();
        }
    }

    @Test
    void testSimple() {
        DbRepresentation someData = this.createSomeData();
        this.managementService = this.dbmsReadOnly();
        GraphDatabaseService readGraphDb = this.managementService.database("neo4j");
        Assertions.assertEquals((Object)someData, (Object)DbRepresentation.of((GraphDatabaseService)readGraphDb));
        Assertions.assertThrows(WriteOperationsNotAllowedException.class, () -> {
            try (Transaction tx = readGraphDb.beginTx();){
                tx.createNode();
                tx.commit();
            }
        });
    }

    @Test
    void databaseNotStartInReadOnlyModeWithMissingIndex() throws IOException {
        this.createIndex();
        this.deleteIndexFolder();
        AssertableLogProvider logProvider = new AssertableLogProvider();
        this.managementService = this.dbmsReadOnly((LogProvider)logProvider);
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.managementService.database("neo4j");
        NamedDatabaseId namedDatabaseId = db.databaseId();
        Assertions.assertFalse((boolean)db.isAvailable(1L), (String)"Did not expect db to start");
        LogAssertions.assertThat((AssertableLogProvider)logProvider).assertExceptionForLogMessage("[" + namedDatabaseId.logPrefix() + "] Exception occurred while starting the database. Trying to stop already started components.").hasMessageContaining("Some indexes need to be rebuilt. This is not allowed in read only mode. Please start db in writable mode to rebuild indexes. Indexes needing rebuild: ");
    }

    @Test
    void testReadOnlyOperationsAndNoTransaction() {
        this.managementService = this.dbms();
        GraphDatabaseService db = this.managementService.database("neo4j");
        Transaction tx = db.beginTx();
        Node node1 = tx.createNode();
        Node node2 = tx.createNode();
        Relationship rel = node1.createRelationshipTo(node2, RelationshipType.withName((String)"TEST"));
        node1.setProperty("key1", (Object)"value1");
        rel.setProperty("key1", (Object)"value1");
        tx.commit();
        Assertions.assertThrows(NotInTransactionException.class, () -> node1.createRelationshipTo(node2, RelationshipType.withName((String)"TEST2")));
        Assertions.assertThrows(NotInTransactionException.class, () -> node1.setProperty("key1", (Object)"value2"));
        Assertions.assertThrows(NotInTransactionException.class, () -> rel.removeProperty("key1"));
        try (Transaction transaction = db.beginTx();){
            Assertions.assertEquals((Object)node1, (Object)transaction.getNodeById(node1.getId()));
            Assertions.assertEquals((Object)node2, (Object)transaction.getNodeById(node2.getId()));
            Assertions.assertEquals((Object)rel, (Object)transaction.getRelationshipById(rel.getId()));
            Node loadedNode = transaction.getNodeById(node1.getId());
            Assertions.assertEquals((Object)"value1", (Object)loadedNode.getProperty("key1"));
            Relationship loadedRel = loadedNode.getSingleRelationship(RelationshipType.withName((String)"TEST"), Direction.OUTGOING);
            Assertions.assertEquals((Object)rel, (Object)loadedRel);
            Assertions.assertEquals((Object)"value1", (Object)loadedRel.getProperty("key1"));
        }
    }

    private void createIndex() {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath()).setFileSystem((FileSystemAbstraction)new UncloseableDelegatingFileSystemAbstraction((FileSystemAbstraction)this.fs)).impermanent().build();
        GraphDatabaseService db = managementService.database("neo4j");
        try (Transaction tx = db.beginTx();){
            tx.schema().indexFor(Label.label((String)"label")).on("prop").create();
            tx.commit();
        }
        tx = db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        managementService.shutdown();
    }

    private void deleteIndexFolder() throws IOException {
        Path databaseDir = Neo4jLayout.of((Path)this.testDirectory.homePath()).databaseLayout("neo4j").databaseDirectory();
        this.fs.deleteRecursively(IndexDirectoryStructure.baseSchemaIndexFolder((Path)databaseDir));
    }

    private DbRepresentation createSomeData() {
        RelationshipType type = RelationshipType.withName((String)"KNOWS");
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath()).setFileSystem((FileSystemAbstraction)new UncloseableDelegatingFileSystemAbstraction((FileSystemAbstraction)this.fs)).impermanent().build();
        GraphDatabaseService db = managementService.database("neo4j");
        try (Transaction tx = db.beginTx();){
            Node prevNode = tx.createNode();
            for (int i = 0; i < 100; ++i) {
                Node node = tx.createNode();
                Relationship rel = prevNode.createRelationshipTo(node, type);
                node.setProperty("someKey" + i % 10, (Object)(i % 15));
                rel.setProperty("since", (Object)System.currentTimeMillis());
            }
            tx.commit();
        }
        DbRepresentation result = DbRepresentation.of((GraphDatabaseService)db);
        managementService.shutdown();
        return result;
    }

    private DatabaseManagementService dbmsReadOnly(LogProvider logProvider) {
        return new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath()).setFileSystem((FileSystemAbstraction)new UncloseableDelegatingFileSystemAbstraction((FileSystemAbstraction)this.fs)).impermanent().setConfig(GraphDatabaseSettings.read_only_database_default, (Object)true).setInternalLogProvider(logProvider).build();
    }

    private DatabaseManagementService dbmsReadOnly() {
        return new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath()).setFileSystem((FileSystemAbstraction)new UncloseableDelegatingFileSystemAbstraction((FileSystemAbstraction)this.fs)).impermanent().setConfig(GraphDatabaseSettings.read_only_database_default, (Object)true).build();
    }

    private DatabaseManagementService dbms() {
        return new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath()).setFileSystem((FileSystemAbstraction)this.fs).impermanent().build();
    }
}

