/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.nio.file.Path;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.internal.recordstorage.RecordStorageCommandReaderFactory;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.format.standard.Standard;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogInitializer;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
class TransactionLogInitializerTest {
    @Inject
    private TestDirectory testDirectory;

    TransactionLogInitializerTest() {
    }

    @Test
    void shouldResetMetaDataStoreWithTransactionId() throws Exception {
        MetadataProvider metaStore = (MetadataProvider)Mockito.mock(MetadataProvider.class);
        TransactionId txn = new TransactionId(3L, -1322858814, System.currentTimeMillis());
        Mockito.when((Object)metaStore.getStoreId()).thenReturn((Object)new StoreId(MetaDataStore.versionStringToLong((String)Standard.LATEST_STORE_VERSION)));
        Mockito.when((Object)metaStore.getLastClosedTransaction()).thenReturn((Object)new long[]{txn.transactionId(), 0L, 1613L});
        Mockito.when((Object)metaStore.getLastCommittedTransaction()).thenReturn((Object)txn);
        Mockito.when((Object)metaStore.getLastCommittedTransactionId()).thenReturn((Object)txn.transactionId());
        Mockito.when((Object)metaStore.getLastClosedTransactionId()).thenReturn((Object)txn.transactionId());
        DatabaseLayout databaseLayout = Neo4jLayout.of((Path)this.testDirectory.homePath()).databaseLayout("neo4j");
        TransactionLogInitializer initializer = new TransactionLogInitializer(this.testDirectory.getFileSystem(), metaStore, (CommandReaderFactory)RecordStorageCommandReaderFactory.INSTANCE, PageCacheTracer.NULL);
        initializer.initializeEmptyLogFile(databaseLayout, databaseLayout.getTransactionLogsDirectory(), "LostFiles");
        ((MetadataProvider)Mockito.verify((Object)metaStore)).resetLastClosedTransaction(ArgumentMatchers.eq((long)txn.transactionId()), ArgumentMatchers.eq((long)txn.transactionId()), ArgumentMatchers.eq((long)64L), ArgumentMatchers.eq((boolean)true), (CursorContext)ArgumentMatchers.any());
    }
}

