/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.IndexingTestUtil;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.kernel.recovery.RecoveryHelpers;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.Unzip;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.pagecache.PageCacheSupportExtension;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
class RecoveryWithTokenIndexesIT {
    @RegisterExtension
    static final PageCacheSupportExtension pageCacheExtension = new PageCacheSupportExtension();
    @Inject
    private DefaultFileSystemAbstraction fileSystem;
    @Inject
    private TestDirectory testDirectory;
    private DatabaseManagementService managementService;
    private Config config;
    private static final Label label = Label.label((String)"label");
    private static final RelationshipType type = RelationshipType.withName((String)"type");

    RecoveryWithTokenIndexesIT() {
    }

    @AfterEach
    void tearDown() {
        if (this.managementService != null) {
            this.managementService.shutdown();
            this.managementService = null;
        }
    }

    private static Stream<Arguments> arguments() {
        return Stream.of(Arguments.of((Object[])new Object[]{"indexes created during recovery", false}), Arguments.of((Object[])new Object[]{"indexes updated during recovery", true}));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"arguments"})
    void recoverDatabaseWithTokenIndexes(String name, boolean checkpointIndexes) throws Throwable {
        this.config = Config.newBuilder().set(GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.homePath()).build();
        EphemeralFileSystemAbstraction fs = new EphemeralFileSystemAbstraction();
        GraphDatabaseService db = this.startDatabase(fs);
        IndexingTestUtil.assertOnlyDefaultTokenIndexesExists(db);
        if (checkpointIndexes) {
            RecoveryWithTokenIndexesIT.checkPoint(db);
        }
        int numberOfEntities = 10;
        for (int i = 0; i < numberOfEntities; ++i) {
            this.createEntities(db);
        }
        EphemeralFileSystemAbstraction crashedFs = fs.snapshot();
        this.managementService.shutdown();
        fs.close();
        try (PageCache cache = pageCacheExtension.getPageCache((FileSystemAbstraction)crashedFs);){
            DatabaseLayout layout = DatabaseLayout.of((Config)this.config);
            this.recoverDatabase(layout, (FileSystemAbstraction)crashedFs, cache);
        }
        db = this.startDatabase(crashedFs);
        IndexingTestUtil.assertOnlyDefaultTokenIndexesExists(db);
        RecoveryWithTokenIndexesIT.awaitIndexesOnline(db);
        try (Transaction tx = db.beginTx();){
            org.junit.jupiter.api.Assertions.assertEquals((long)numberOfEntities, (long)tx.findNodes(label).stream().count());
            org.junit.jupiter.api.Assertions.assertEquals((long)numberOfEntities, (long)tx.findRelationships(type).stream().count());
        }
    }

    @Test
    void recoverDatabaseWithInjectedTokenIndex() throws Throwable {
        this.config = Config.newBuilder().set(GraphDatabaseSettings.allow_single_automatic_upgrade, (Object)false).set(GraphDatabaseSettings.allow_upgrade, (Object)true).build();
        int numberOfEntities = 10;
        GraphDatabaseService database = this.createDatabaseOfOlderVersion("4-2-data-10-nodes-rels.zip");
        DatabaseLayout layout = ((GraphDatabaseAPI)database).databaseLayout();
        this.verifyInjectedNLIExistAndOnline(database);
        this.managementService.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)layout, (FileSystemAbstraction)this.fileSystem);
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)layout, (FileSystemAbstraction)this.fileSystem);
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)layout, (FileSystemAbstraction)this.fileSystem);
        try (PageCache pageCache = pageCacheExtension.getPageCache((FileSystemAbstraction)this.fileSystem);){
            this.recoverDatabaseOfOlderVersion(layout, pageCache);
        }
        GraphDatabaseService recoveredDatabase = this.startDatabaseOfOlderVersion();
        this.verifyInjectedNLIExistAndOnline(recoveredDatabase);
        try (Transaction tx = recoveredDatabase.beginTx();){
            org.junit.jupiter.api.Assertions.assertEquals((long)numberOfEntities, (long)tx.findNodes(label).stream().count());
            org.junit.jupiter.api.Assertions.assertEquals((long)numberOfEntities, (long)tx.findRelationships(type).stream().count());
        }
    }

    @Test
    void recoverDatabaseWithPersistedTokenIndex() throws Throwable {
        this.config = Config.newBuilder().set(GraphDatabaseSettings.allow_single_automatic_upgrade, (Object)true).set(GraphDatabaseSettings.allow_upgrade, (Object)true).build();
        int numberOfEntities = 10;
        GraphDatabaseService database = this.createDatabaseOfOlderVersion("4-2-data-10-nodes-rels.zip");
        DatabaseLayout layout = ((GraphDatabaseAPI)database).databaseLayout();
        this.verifyInjectedNLIExistAndOnline(database);
        try (Transaction tx = database.beginTx();){
            tx.createNode();
            tx.commit();
        }
        IndexDescriptor persistedNLI = IndexDescriptor.NLI_PROTOTYPE.materialise(1L);
        this.verifyIndexExistAndOnline(database, persistedNLI);
        this.managementService.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)layout, (FileSystemAbstraction)this.fileSystem);
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)layout, (FileSystemAbstraction)this.fileSystem);
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)layout, (FileSystemAbstraction)this.fileSystem);
        try (PageCache pageCache = pageCacheExtension.getPageCache((FileSystemAbstraction)this.fileSystem);){
            this.recoverDatabaseOfOlderVersion(layout, pageCache);
        }
        GraphDatabaseService recoveredDatabase = this.startDatabaseOfOlderVersion();
        this.verifyIndexExistAndOnline(recoveredDatabase, persistedNLI);
        try (Transaction tx = recoveredDatabase.beginTx();){
            org.junit.jupiter.api.Assertions.assertEquals((long)numberOfEntities, (long)tx.findNodes(label).stream().count());
            org.junit.jupiter.api.Assertions.assertEquals((long)numberOfEntities, (long)tx.findRelationships(type).stream().count());
        }
    }

    private static void checkPoint(GraphDatabaseService db) throws IOException {
        ((CheckPointer)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(CheckPointer.class)).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("Manual trigger"));
    }

    private static void awaitIndexesOnline(GraphDatabaseService database) {
        try (Transaction transaction = database.beginTx();){
            transaction.schema().awaitIndexesOnline(10L, TimeUnit.MINUTES);
            transaction.commit();
        }
    }

    private void verifyInjectedNLIExistAndOnline(GraphDatabaseService db) {
        this.verifyIndexExistAndOnline(db, IndexDescriptor.INJECTED_NLI);
    }

    private void verifyIndexExistAndOnline(GraphDatabaseService db, IndexDescriptor index) {
        RecoveryWithTokenIndexesIT.awaitIndexesOnline(db);
        try (Transaction tx = db.beginTx();){
            List indexes = StreamSupport.stream(tx.schema().getIndexes().spliterator(), false).map(IndexDefinitionImpl.class::cast).map(IndexDefinitionImpl::getIndexReference).collect(Collectors.toList());
            Assertions.assertThat(indexes).hasSize(1);
            Assertions.assertThat((Object)((IndexDescriptor)indexes.get(0))).isEqualTo((Object)index);
        }
    }

    private GraphDatabaseService createDatabaseOfOlderVersion(String databaseArchiveName) throws IOException {
        Unzip.unzip(this.getClass(), (String)databaseArchiveName, (Path)this.testDirectory.homePath());
        return this.startDatabaseOfOlderVersion();
    }

    private GraphDatabaseService startDatabaseOfOlderVersion() {
        this.managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath()).setConfig(this.config).build();
        return this.managementService.database("neo4j");
    }

    private void recoverDatabaseOfOlderVersion(DatabaseLayout layout, PageCache pageCache) throws Exception {
        this.recoverDatabase(layout, (FileSystemAbstraction)this.fileSystem, pageCache);
    }

    private GraphDatabaseService startDatabase(EphemeralFileSystemAbstraction fs) {
        this.managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath()).setFileSystem((FileSystemAbstraction)fs).impermanent().setConfig(this.config).build();
        return this.managementService.database("neo4j");
    }

    private void recoverDatabase(DatabaseLayout layout, FileSystemAbstraction fs, PageCache cache) throws Exception {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Recovery.isRecoveryRequired((FileSystemAbstraction)fs, (DatabaseLayout)layout, (Config)this.config, (MemoryTracker)EmptyMemoryTracker.INSTANCE));
        Recovery.performRecovery((FileSystemAbstraction)fs, (PageCache)cache, (DatabaseTracers)DatabaseTracers.EMPTY, (Config)this.config, (DatabaseLayout)layout, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)Recovery.isRecoveryRequired((FileSystemAbstraction)fs, (DatabaseLayout)layout, (Config)this.config, (MemoryTracker)EmptyMemoryTracker.INSTANCE));
    }

    private void createEntities(GraphDatabaseService service) {
        try (Transaction transaction = service.beginTx();){
            Node node = transaction.createNode(new Label[]{label});
            node.createRelationshipTo(node, type);
            transaction.commit();
        }
    }
}

