/*
 * Decompiled with CFR 0.152.
 */
package migration;

import java.nio.file.Path;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Values;

@TestDirectoryExtension
class PointPropertiesRecordFormatIT {
    @Inject
    private TestDirectory testDirectory;

    PointPropertiesRecordFormatIT() {
    }

    @Test
    void createPointPropertyOnLatestDatabase() {
        Path storeDir = this.testDirectory.homePath();
        Label pointNode = Label.label((String)"PointNode");
        String propertyKey = "a";
        PointValue pointValue = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{1.0, 2.0});
        DatabaseManagementService managementService = PointPropertiesRecordFormatIT.startDatabaseService(storeDir);
        GraphDatabaseService database = PointPropertiesRecordFormatIT.getDefaultDatabase(managementService);
        try (Transaction transaction = database.beginTx();){
            Node node = transaction.createNode(new Label[]{pointNode});
            node.setProperty(propertyKey, (Object)pointValue);
            transaction.commit();
        }
        managementService.shutdown();
        managementService = PointPropertiesRecordFormatIT.startDatabaseService(storeDir);
        GraphDatabaseService restartedDatabase = PointPropertiesRecordFormatIT.getDefaultDatabase(managementService);
        try (Transaction transaction = restartedDatabase.beginTx();){
            org.junit.jupiter.api.Assertions.assertNotNull((Object)transaction.findNode(pointNode, propertyKey, (Object)pointValue));
        }
        managementService.shutdown();
    }

    @Test
    void createPointArrayPropertyOnLatestDatabase() {
        Path storeDir = this.testDirectory.homePath();
        Label pointNode = Label.label((String)"PointNode");
        String propertyKey = "a";
        PointValue pointValue = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{1.0, 2.0});
        DatabaseManagementService managementService = PointPropertiesRecordFormatIT.startDatabaseService(storeDir);
        GraphDatabaseService database = PointPropertiesRecordFormatIT.getDefaultDatabase(managementService);
        try (Transaction transaction = database.beginTx();){
            Node node = transaction.createNode(new Label[]{pointNode});
            node.setProperty(propertyKey, (Object)new PointValue[]{pointValue, pointValue});
            transaction.commit();
        }
        managementService.shutdown();
        managementService = PointPropertiesRecordFormatIT.startDatabaseService(storeDir);
        GraphDatabaseService restartedDatabase = PointPropertiesRecordFormatIT.getDefaultDatabase(managementService);
        try (Transaction tx = restartedDatabase.beginTx();
             ResourceIterator nodes = tx.findNodes(pointNode);){
            Node node = (Node)nodes.next();
            Object[] points = (PointValue[])node.getProperty(propertyKey);
            Assertions.assertThat((Object[])points).hasSize(2);
        }
        managementService.shutdown();
    }

    private static DatabaseManagementService startDatabaseService(Path storeDir) {
        return new TestDatabaseManagementServiceBuilder(storeDir).build();
    }

    private static GraphDatabaseService getDefaultDatabase(DatabaseManagementService managementService) {
        return managementService.database("neo4j");
    }
}

