/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrderCapability;
import org.neo4j.internal.schema.IndexValueCapability;
import org.neo4j.kernel.api.index.IndexProviderCompatibilityTestSuite;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueCategory;
import org.neo4j.values.storable.Values;

@Ignore(value="Not a test. This is a compatibility suite that provides test cases for verifying IndexProvider implementations. Each index provider that is to be tested by this suite must create their own test class extending IndexProviderCompatibilityTestSuite. The @Ignore annotation doesn't prevent these tests to run, it rather removes some annoying errors or warnings in some IDEs about test classes needing a public zero-arg constructor.")
public class IndexConfigurationCompletionCompatibility
extends IndexProviderCompatibilityTestSuite.Compatibility {
    public IndexConfigurationCompletionCompatibility(IndexProviderCompatibilityTestSuite testSuite) {
        super(testSuite, testSuite.indexPrototype());
    }

    @Test
    public void configurationCompletionMustNotOverwriteExistingConfiguration() {
        IndexDescriptor index = this.descriptor;
        index = index.withIndexConfig(IndexConfig.with((String)"Bob", (Value)Values.stringValue((String)"Howard")));
        index = this.indexProvider.completeConfiguration(index);
        Assert.assertEquals((Object)index.getIndexConfig().get("Bob"), (Object)Values.stringValue((String)"Howard"));
    }

    @Test
    public void configurationCompletionMustBeIdempotent() {
        IndexDescriptor index = this.descriptor;
        IndexDescriptor onceCompleted = this.indexProvider.completeConfiguration(index);
        IndexDescriptor twiceCompleted = this.indexProvider.completeConfiguration(onceCompleted);
        Assert.assertEquals((Object)onceCompleted.getIndexConfig(), (Object)twiceCompleted.getIndexConfig());
    }

    @Test
    public void mustAssignCapabilitiesToDescriptorsThatHaveNone() {
        IndexDescriptor index = this.descriptor;
        IndexDescriptor completed = this.indexProvider.completeConfiguration(index);
        Assert.assertNotEquals((Object)completed.getCapability(), (Object)IndexCapability.NO_CAPABILITY);
        completed = completed.withIndexCapability(IndexCapability.NO_CAPABILITY);
        completed = this.indexProvider.completeConfiguration(completed);
        Assert.assertNotEquals((Object)completed.getCapability(), (Object)IndexCapability.NO_CAPABILITY);
    }

    @Test
    public void mustNotOverwriteExistingCapabilities() {
        IndexCapability capability = new IndexCapability(){

            public IndexOrderCapability orderCapability(ValueCategory ... valueCategories) {
                return IndexOrderCapability.NONE;
            }

            public IndexValueCapability valueCapability(ValueCategory ... valueCategories) {
                return IndexValueCapability.NO;
            }
        };
        IndexDescriptor index = this.descriptor.withIndexCapability(capability);
        IndexDescriptor completed = this.indexProvider.completeConfiguration(index);
        Assert.assertSame((Object)capability, (Object)completed.getCapability());
    }
}

