/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.internal.helpers.ArrayUtil;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.internal.recordstorage.SchemaRuleAccess;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.UncloseableDelegatingFileSystemAbstraction;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingController;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.EphemeralFileSystemExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.token.TokenHolders;

@ExtendWith(value={EphemeralFileSystemExtension.class})
class IndexStatisticsIT {
    private static final Label ALIEN = Label.label((String)"Alien");
    private static final String SPECIMEN = "specimen";
    @Inject
    private EphemeralFileSystemAbstraction fs;
    private final AssertableLogProvider logProvider = new AssertableLogProvider(true);
    private GraphDatabaseService db;
    private DatabaseManagementService managementService;

    IndexStatisticsIT() {
    }

    @BeforeEach
    void before() {
        this.startDb();
    }

    @AfterEach
    void after() {
        this.managementService.shutdown();
    }

    @Test
    void shouldRecoverIndexCountsBySamplingThemOnStartup() {
        this.createAliens();
        this.awaitIndexOnline(this.indexAliensBySpecimen());
        IndexDescriptor index = TestIndexDescriptorFactory.forLabel((int)this.labelId(ALIEN), (int[])new int[]{this.pkId(SPECIMEN)});
        SchemaRuleAccess schemaRuleAccess = SchemaRuleAccess.getSchemaRuleAccess((SchemaStore)this.neoStores().getSchemaStore(), (TokenHolders)this.resolveDependency(TokenHolders.class), () -> KernelVersion.LATEST);
        long indexId = ((IndexDescriptor)ArrayUtil.single((Object[])schemaRuleAccess.indexGetForSchema((SchemaDescriptorSupplier)index, CursorContext.NULL))).getId();
        this.resetIndexCounts(indexId);
        this.restart();
        IndexStatisticsStore indexStatisticsStore = this.indexStatistics();
        IndexSample indexSample = indexStatisticsStore.indexSample(indexId);
        Assertions.assertEquals((long)0L, (long)indexSample.updates());
        Assertions.assertEquals((long)32L, (long)indexSample.indexSize());
        Assertions.assertEquals((long)16L, (long)indexSample.uniqueValues());
        Assertions.assertEquals((long)32L, (long)indexSample.sampleSize());
        this.assertLogExistsForRecoveryOn("(:Alien {specimen})");
    }

    private void assertLogExistsForRecoveryOn(String labelAndProperty) {
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).forClass(IndexSamplingController.class).forLevel(AssertableLogProvider.Level.DEBUG).containsMessages(new String[]{"Recovering index sampling for index %s", labelAndProperty});
    }

    private int labelId(Label alien) {
        try (Transaction tx = this.db.beginTx();){
            int n = ((InternalTransaction)tx).kernelTransaction().tokenRead().nodeLabel(alien.name());
            return n;
        }
    }

    private int pkId(String propertyName) {
        try (Transaction tx = this.db.beginTx();){
            int n = ((InternalTransaction)tx).kernelTransaction().tokenRead().propertyKey(propertyName);
            return n;
        }
    }

    private void createAliens() {
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < 32; ++i) {
                Node alien = tx.createNode(new Label[]{ALIEN});
                alien.setProperty(SPECIMEN, (Object)(i / 2));
            }
            tx.commit();
        }
    }

    private void awaitIndexOnline(IndexDefinition definition) {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexOnline(definition, 10L, TimeUnit.MINUTES);
            tx.commit();
        }
    }

    private IndexDefinition indexAliensBySpecimen() {
        try (Transaction tx = this.db.beginTx();){
            IndexDefinition definition = tx.schema().indexFor(ALIEN).on(SPECIMEN).create();
            tx.commit();
            IndexDefinition indexDefinition = definition;
            return indexDefinition;
        }
    }

    private void resetIndexCounts(long indexId) {
        this.indexStatistics().replaceStats(indexId, new IndexSample(0L, 0L, 0L));
    }

    private <T> T resolveDependency(Class<T> clazz) {
        return (T)((GraphDatabaseAPI)this.db).getDependencyResolver().resolveDependency(clazz);
    }

    private NeoStores neoStores() {
        return this.resolveDependency(RecordStorageEngine.class).testAccessNeoStores();
    }

    private IndexStatisticsStore indexStatistics() {
        return (IndexStatisticsStore)((GraphDatabaseAPI)this.db).getDependencyResolver().resolveDependency(IndexStatisticsStore.class);
    }

    private void startDb() {
        this.managementService = new TestDatabaseManagementServiceBuilder().setInternalLogProvider((LogProvider)this.logProvider).setFileSystem((FileSystemAbstraction)new UncloseableDelegatingFileSystemAbstraction((FileSystemAbstraction)this.fs)).impermanent().setConfig(GraphDatabaseSettings.index_background_sampling_enabled, (Object)false).build();
        this.db = this.managementService.database("neo4j");
    }

    private void restart() {
        this.managementService.shutdown();
        this.startDb();
    }
}

