/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
class NodeManagerTest {
    @Inject
    GraphDatabaseService db;

    NodeManagerTest() {
    }

    @Test
    void getAllNodesIteratorShouldPickUpHigherIdsThanHighIdWhenStarted() throws Exception {
        try (Transaction tx = this.db.beginTx();){
            tx.createNode();
            tx.createNode();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            ResourceIterator allNodes = tx.getAllNodes().iterator();
            allNodes.next();
            Thread thread = new Thread(() -> {
                Transaction newTx = this.db.beginTx();
                newTx.createNode();
                newTx.commit();
            });
            thread.start();
            thread.join();
            Assertions.assertThat((long)Iterators.count((Iterator)allNodes)).isEqualTo(2L);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void getAllRelationshipsIteratorShouldPickUpHigherIdsThanHighIdWhenStarted() throws Exception {
        try (Transaction tx = this.db.beginTx();){
            this.createRelationshipAssumingTxWith(tx, "key", 1);
            this.createRelationshipAssumingTxWith(tx, "key", 2);
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            ResourceIterator allRelationships = tx.getAllRelationships().iterator();
            allRelationships.next();
            Thread thread = new Thread(() -> {
                Transaction newTx = this.db.beginTx();
                this.createRelationshipAssumingTxWith(newTx, "key", 3);
                newTx.commit();
            });
            thread.start();
            thread.join();
            Assertions.assertThat((long)Iterators.count((Iterator)allRelationships)).isEqualTo(2L);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private void createRelationshipAssumingTxWith(Transaction transaction, String key, Object value) {
        Node a = transaction.createNode();
        Node b = transaction.createNode();
        Relationship relationship = a.createRelationshipTo(b, RelationshipType.withName((String)"FOO"));
        relationship.setProperty(key, value);
    }
}

