/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.common.EntityType;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.kernel.api.TokenReadSession;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.TokenIndexOrderTestBase;

public class NodeLabelIndexOrderTest
extends TokenIndexOrderTestBase<NodeLabelIndexCursor> {
    @Override
    protected NodeLabelIndexCursor getIndexCursor(KernelTransaction tx) {
        return tx.cursors().allocateNodeLabelIndexCursor(tx.cursorContext());
    }

    @Override
    protected long entityReference(NodeLabelIndexCursor cursor) {
        return cursor.nodeReference();
    }

    @Override
    protected void tokenScan(IndexOrder indexOrder, KernelTransaction tx, int label, NodeLabelIndexCursor cursor) throws KernelException {
        IndexDescriptor index = (IndexDescriptor)tx.schemaRead().index((SchemaDescriptor)SchemaDescriptor.forAnyEntityTokens((EntityType)EntityType.NODE)).next();
        TokenReadSession tokenReadSession = tx.dataRead().tokenReadSession(index);
        tx.dataRead().nodeLabelScan(tokenReadSession, cursor, IndexQueryConstraints.ordered((IndexOrder)indexOrder), new TokenPredicate(label));
    }

    @Override
    protected int tokenByName(KernelTransaction tx, String name) {
        return tx.tokenRead().nodeLabel(name);
    }

    @Override
    protected long entityWithToken(KernelTransaction tx, String name) throws Exception {
        Write write = tx.dataWrite();
        long node = write.nodeCreate();
        write.nodeAddLabel(node, tx.tokenWrite().labelGetOrCreateForName(name));
        return node;
    }
}

