/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import org.apache.commons.lang3.RandomStringUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.api.index.TokenScanConsumer;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.transaction.state.storeview.DynamicIndexStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.FullScanStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.TestTokenScanConsumer;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.lock.LockService;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class DynamicIndexStoreViewTracingIT {
    @Inject
    private GraphDatabaseAPI database;
    @Inject
    private LockService lockService;
    @Inject
    private Locks locks;
    @Inject
    private IndexingService indexingService;
    @Inject
    private RecordStorageEngine storageEngine;
    private final JobScheduler jobScheduler = JobSchedulerFactory.createInitialisedScheduler();

    DynamicIndexStoreViewTracingIT() {
    }

    @AfterEach
    void closeJobScheduler() throws Exception {
        this.jobScheduler.close();
    }

    @Test
    void tracePageCacheAccess() {
        int nodeCount = 1000;
        Label label = Label.label((String)"marker");
        try (Transaction tx = this.database.beginTx();){
            for (int i = 0; i < nodeCount; ++i) {
                Node node = tx.createNode(new Label[]{label});
                node.setProperty("a", (Object)RandomStringUtils.randomAscii((int)10));
            }
            tx.commit();
        }
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
        FullScanStoreView neoStoreStoreView = new FullScanStoreView(this.lockService, () -> ((RecordStorageEngine)this.storageEngine).newReader(), Config.defaults(), this.jobScheduler);
        DynamicIndexStoreView indexStoreView = new DynamicIndexStoreView(neoStoreStoreView, this.locks, this.lockService, Config.defaults(), indexDescriptor -> this.indexingService.getIndexProxy(indexDescriptor), () -> ((RecordStorageEngine)this.storageEngine).newReader(), (LogProvider)NullLogProvider.nullLogProvider());
        StoreScan storeScan = indexStoreView.visitNodes(new int[]{0, 1, 2}, Predicates.ALWAYS_TRUE_INT, null, (TokenScanConsumer)new TestTokenScanConsumer(), false, true, (PageCacheTracer)pageCacheTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        storeScan.run(StoreScan.NO_EXTERNAL_UPDATES);
        Assertions.assertThat((long)pageCacheTracer.pins()).isEqualTo(5L);
        Assertions.assertThat((long)pageCacheTracer.unpins()).isEqualTo(5L);
        Assertions.assertThat((long)pageCacheTracer.hits()).isEqualTo(5L);
    }
}

