/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal.event;

import java.util.List;
import org.apache.commons.lang3.RandomStringUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.internal.event.LabelEntryView;
import org.neo4j.kernel.internal.event.NodePropertyEntryView;
import org.neo4j.kernel.internal.event.RelationshipPropertyEntryView;
import org.neo4j.kernel.internal.event.TxStateTransactionDataSnapshot;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class TxStateTransactionDataSnapshotIT {
    @Inject
    private GraphDatabaseAPI database;
    private long emptySnapshotSize;

    TxStateTransactionDataSnapshotIT() {
    }

    @BeforeEach
    void setUp() {
        this.emptySnapshotSize = this.countEmptySnapshotSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void countRemovedNodeWithPropertiesInTransactionStateSnapshot() {
        long nodeIdToDelete;
        int attachedPropertySize = (int)ByteUnit.mebiBytes((long)1L);
        try (Transaction transaction = this.database.beginTx();){
            Node node = transaction.createNode(new Label[]{Label.label((String)"label1"), Label.label((String)"label2")});
            node.setProperty("a", (Object)RandomStringUtils.randomAscii((int)attachedPropertySize));
            node.setProperty("b", (Object)RandomStringUtils.randomAscii((int)attachedPropertySize));
            nodeIdToDelete = node.getId();
            transaction.commit();
        }
        transaction = this.database.beginTx();
        try {
            transaction.getNodeById(nodeIdToDelete).delete();
            KernelTransactionImplementation kernelTransaction = this.getKernelTransaction(transaction);
            TransactionState transactionState = kernelTransaction.txState();
            MemoryTracker memoryTracker = kernelTransaction.memoryTracker();
            MemoryTrackingData trackingData = TxStateTransactionDataSnapshotIT.resetMemoryTracker(memoryTracker);
            try (TxStateTransactionDataSnapshot snapshot = new TxStateTransactionDataSnapshot((ReadableTransactionState)transactionState, kernelTransaction.newStorageReader(), (KernelTransaction)kernelTransaction);){
                Assertions.assertThat((long)memoryTracker.usedNativeMemory()).isZero();
                Assertions.assertThat((long)memoryTracker.estimatedHeapMemory()).isGreaterThanOrEqualTo(this.emptySnapshotSize + (long)(2 * attachedPropertySize) + 2L * NodePropertyEntryView.SHALLOW_SIZE + 2L * LabelEntryView.SHALLOW_SIZE);
            }
            finally {
                TxStateTransactionDataSnapshotIT.restoreMemoryTracker(memoryTracker, trackingData);
            }
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void countRemovedRelationshipsWithPropertiesInTransactionStateSnapshot() {
        List<Long> relationshipsIdToDelete;
        int attachedPropertySize = (int)ByteUnit.mebiBytes((long)1L);
        try (Transaction transaction = this.database.beginTx();){
            Node start = transaction.createNode();
            Node end = transaction.createNode();
            Relationship relationship1 = start.createRelationshipTo(end, RelationshipType.withName((String)"type1"));
            Relationship relationship2 = start.createRelationshipTo(end, RelationshipType.withName((String)"type2"));
            relationship1.setProperty("a", (Object)RandomStringUtils.randomAscii((int)attachedPropertySize));
            relationship2.setProperty("a", (Object)RandomStringUtils.randomAscii((int)attachedPropertySize));
            relationship2.setProperty("b", (Object)RandomStringUtils.randomAscii((int)attachedPropertySize));
            relationshipsIdToDelete = List.of(Long.valueOf(relationship1.getId()), Long.valueOf(relationship2.getId()));
            transaction.commit();
        }
        Assertions.assertThat(relationshipsIdToDelete).hasSize(2);
        transaction = this.database.beginTx();
        try {
            relationshipsIdToDelete.forEach(id -> transaction.getRelationshipById(id.longValue()).delete());
            KernelTransactionImplementation kernelTransaction = this.getKernelTransaction(transaction);
            TransactionState transactionState = kernelTransaction.txState();
            MemoryTracker memoryTracker = kernelTransaction.memoryTracker();
            MemoryTrackingData trackingData = TxStateTransactionDataSnapshotIT.resetMemoryTracker(memoryTracker);
            try (TxStateTransactionDataSnapshot snapshot = new TxStateTransactionDataSnapshot((ReadableTransactionState)transactionState, kernelTransaction.newStorageReader(), (KernelTransaction)kernelTransaction);){
                Assertions.assertThat((long)memoryTracker.usedNativeMemory()).isZero();
                Assertions.assertThat((long)memoryTracker.estimatedHeapMemory()).isGreaterThanOrEqualTo(this.emptySnapshotSize + (long)(3 * attachedPropertySize) + 2L * RelationshipPropertyEntryView.SHALLOW_SIZE);
            }
            finally {
                TxStateTransactionDataSnapshotIT.restoreMemoryTracker(memoryTracker, trackingData);
            }
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void countChangedNodeInTransactionStateSnapshot() {
        long nodeIdToChange;
        Node node;
        int attachedPropertySize = (int)ByteUnit.mebiBytes((long)1L);
        int doublePropertySize = attachedPropertySize * 2;
        Label label1 = Label.label((String)"label1");
        Label label2 = Label.label((String)"label2");
        String property = "a";
        String doubleProperty = "b";
        try (Transaction transaction = this.database.beginTx();){
            node = transaction.createNode(new Label[]{label1, label2});
            node.setProperty("a", (Object)RandomStringUtils.randomAscii((int)attachedPropertySize));
            node.setProperty("b", (Object)RandomStringUtils.randomAscii((int)doublePropertySize));
            nodeIdToChange = node.getId();
            transaction.commit();
        }
        transaction = this.database.beginTx();
        try {
            node = transaction.getNodeById(nodeIdToChange);
            node.removeLabel(label1);
            node.setProperty("b", (Object)RandomStringUtils.randomAscii((int)attachedPropertySize));
            node.removeProperty("a");
            node.addLabel(Label.label((String)"newLabel"));
            KernelTransactionImplementation kernelTransaction = this.getKernelTransaction(transaction);
            TransactionState transactionState = kernelTransaction.txState();
            MemoryTracker memoryTracker = kernelTransaction.memoryTracker();
            MemoryTrackingData trackingData = TxStateTransactionDataSnapshotIT.resetMemoryTracker(memoryTracker);
            try (TxStateTransactionDataSnapshot snapshot = new TxStateTransactionDataSnapshot((ReadableTransactionState)transactionState, kernelTransaction.newStorageReader(), (KernelTransaction)kernelTransaction);){
                Assertions.assertThat((long)memoryTracker.usedNativeMemory()).isZero();
                Assertions.assertThat((long)memoryTracker.estimatedHeapMemory()).isGreaterThanOrEqualTo(this.emptySnapshotSize + (long)(attachedPropertySize + doublePropertySize) + 2L * NodePropertyEntryView.SHALLOW_SIZE + 2L * LabelEntryView.SHALLOW_SIZE);
            }
            finally {
                TxStateTransactionDataSnapshotIT.restoreMemoryTracker(memoryTracker, trackingData);
            }
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void countChangedRelationshipInTransactionStateSnapshot() {
        long relationshipIdToChange;
        int attachedPropertySize = (int)ByteUnit.mebiBytes((long)1L);
        int doublePropertySize = attachedPropertySize * 2;
        String property = "a";
        String doubleProperty = "b";
        try (Transaction transaction = this.database.beginTx();){
            Node start = transaction.createNode();
            Node end = transaction.createNode();
            Relationship relationship = start.createRelationshipTo(end, RelationshipType.withName((String)"relType"));
            relationship.setProperty("a", (Object)RandomStringUtils.randomAscii((int)attachedPropertySize));
            relationship.setProperty("b", (Object)RandomStringUtils.randomAscii((int)doublePropertySize));
            relationshipIdToChange = relationship.getId();
            transaction.commit();
        }
        transaction = this.database.beginTx();
        try {
            Relationship relationship = transaction.getRelationshipById(relationshipIdToChange);
            relationship.setProperty("b", (Object)RandomStringUtils.randomAscii((int)attachedPropertySize));
            relationship.removeProperty("a");
            KernelTransactionImplementation kernelTransaction = this.getKernelTransaction(transaction);
            TransactionState transactionState = kernelTransaction.txState();
            MemoryTracker memoryTracker = kernelTransaction.memoryTracker();
            MemoryTrackingData trackingData = TxStateTransactionDataSnapshotIT.resetMemoryTracker(memoryTracker);
            try (TxStateTransactionDataSnapshot snapshot = new TxStateTransactionDataSnapshot((ReadableTransactionState)transactionState, kernelTransaction.newStorageReader(), (KernelTransaction)kernelTransaction);){
                Assertions.assertThat((long)memoryTracker.usedNativeMemory()).isZero();
                Assertions.assertThat((long)memoryTracker.estimatedHeapMemory()).isGreaterThanOrEqualTo(this.emptySnapshotSize + (long)(attachedPropertySize + doublePropertySize) + 2L * RelationshipPropertyEntryView.SHALLOW_SIZE);
            }
            finally {
                TxStateTransactionDataSnapshotIT.restoreMemoryTracker(memoryTracker, trackingData);
            }
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void noPageCacheAccessOnEmptyTransactionSnapshot() {
        try (Transaction transaction = this.database.beginTx();){
            KernelTransactionImplementation kernelTransaction = this.getKernelTransaction(transaction);
            TransactionState transactionState = kernelTransaction.txState();
            CursorContext cursorContext = kernelTransaction.cursorContext();
            TxStateTransactionDataSnapshot snapshot = new TxStateTransactionDataSnapshot((ReadableTransactionState)transactionState, kernelTransaction.newStorageReader(), (KernelTransaction)kernelTransaction);
            snapshot.close();
            this.assertZeroTracer(cursorContext);
        }
    }

    @Test
    void tracePageCacheAccessOnTransactionSnapshotCreation() {
        long relationshipId;
        long nodeId;
        try (Transaction transaction = this.database.beginTx();){
            Node node1 = transaction.createNode();
            Node node2 = transaction.createNode();
            Relationship relationship = node1.createRelationshipTo(node2, RelationshipType.withName((String)"marker"));
            node1.setProperty("foo", (Object)"bar");
            nodeId = node1.getId();
            relationshipId = relationship.getId();
            transaction.commit();
        }
        transaction = this.database.beginTx();
        try {
            transaction.getNodeById(nodeId).delete();
            transaction.getRelationshipById(relationshipId).delete();
            KernelTransactionImplementation kernelTransaction = this.getKernelTransaction(transaction);
            TransactionState transactionState = kernelTransaction.txState();
            CursorContext cursorContext = kernelTransaction.cursorContext();
            PageCursorTracer cursorTracer = cursorContext.getCursorTracer();
            cursorTracer.reportEvents();
            TxStateTransactionDataSnapshot snapshot = new TxStateTransactionDataSnapshot((ReadableTransactionState)transactionState, kernelTransaction.newStorageReader(), (KernelTransaction)kernelTransaction);
            snapshot.close();
            Assertions.assertThat((long)cursorTracer.pins()).isEqualTo(3L);
            Assertions.assertThat((long)cursorTracer.hits()).isEqualTo(3L);
            Assertions.assertThat((long)cursorTracer.unpins()).isEqualTo(3L);
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    private KernelTransactionImplementation getKernelTransaction(Transaction transaction) {
        return (KernelTransactionImplementation)((InternalTransaction)transaction).kernelTransaction();
    }

    private void assertZeroTracer(CursorContext cursorContext) {
        PageCursorTracer cursorTracer = cursorContext.getCursorTracer();
        Assertions.assertThat((long)cursorTracer.pins()).isZero();
        Assertions.assertThat((long)cursorTracer.hits()).isZero();
        Assertions.assertThat((long)cursorTracer.unpins()).isZero();
    }

    private long countEmptySnapshotSize() {
        try (Transaction transaction = this.database.beginTx();){
            long l;
            KernelTransactionImplementation kernelTransaction = this.getKernelTransaction(transaction);
            TransactionState transactionState = kernelTransaction.txState();
            MemoryTracker memoryTracker = kernelTransaction.memoryTracker();
            TxStateTransactionDataSnapshotIT.resetMemoryTracker(memoryTracker);
            try (TxStateTransactionDataSnapshot snapshot = new TxStateTransactionDataSnapshot((ReadableTransactionState)transactionState, kernelTransaction.newStorageReader(), (KernelTransaction)kernelTransaction);){
                l = memoryTracker.estimatedHeapMemory();
            }
            return l;
        }
    }

    private static MemoryTrackingData resetMemoryTracker(MemoryTracker memoryTracker) {
        MemoryTrackingData trackingData = new MemoryTrackingData(memoryTracker.estimatedHeapMemory(), memoryTracker.usedNativeMemory());
        memoryTracker.releaseHeap(trackingData.getHeapUsage());
        memoryTracker.releaseNative(trackingData.getNativeUsage());
        return trackingData;
    }

    private static void restoreMemoryTracker(MemoryTracker memoryTracker, MemoryTrackingData restoreData) {
        memoryTracker.allocateHeap(restoreData.getHeapUsage());
        memoryTracker.allocateNative(restoreData.getNativeUsage());
    }

    private static class MemoryTrackingData {
        private final long heapUsage;
        private final long nativeUsage;

        MemoryTrackingData(long heapUsage, long nativeUsage) {
            this.heapUsage = heapUsage;
            this.nativeUsage = nativeUsage;
        }

        public long getHeapUsage() {
            return this.heapUsage;
        }

        public long getNativeUsage() {
            return this.nativeUsage;
        }
    }
}

