/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Iterator;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.junit.jupiter.api.Test;
import org.neo4j.common.EntityType;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.NodeIndexCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.kernel.api.TokenReadSession;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.AnyTokenSchemaDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.IndexReadAsserts;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestBase;
import org.neo4j.kernel.impl.newapi.WriteTestSupport;

public class NodeLabelTokenIndexCursorTest
extends KernelAPIWriteTestBase<WriteTestSupport> {
    private int labelOne = 1;
    private int labelTwo = 2;
    private int labelThree = 3;
    private int labelFirst = 4;

    @Override
    public WriteTestSupport newTestSupport() {
        return new WriteTestSupport();
    }

    @Test
    void shouldFindNodesByLabel() throws Exception {
        long toDelete;
        try (KernelTransaction tx = this.beginTransaction();){
            this.createNode(tx.dataWrite(), this.labelOne, this.labelFirst);
            this.createNode(tx.dataWrite(), this.labelTwo, this.labelFirst);
            this.createNode(tx.dataWrite(), this.labelThree, this.labelFirst);
            toDelete = this.createNode(tx.dataWrite(), this.labelOne);
            this.createNode(tx.dataWrite(), this.labelTwo);
            this.createNode(tx.dataWrite(), this.labelThree);
            this.createNode(tx.dataWrite(), this.labelThree);
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            tx.dataWrite().nodeDelete(toDelete);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.beginTransaction();
        try {
            Read read = tx.dataRead();
            TokenReadSession session = this.getTokenReadSession(tx);
            try (NodeLabelIndexCursor cursor = tx.cursors().allocateNodeLabelIndexCursor(tx.cursorContext());){
                LongHashSet uniqueIds = new LongHashSet();
                read.nodeLabelScan(session, cursor, IndexQueryConstraints.unconstrained(), new TokenPredicate(this.labelOne));
                IndexReadAsserts.assertNodeCount((NodeIndexCursor)cursor, 1, (MutableLongSet)uniqueIds);
                read.nodeLabelScan(session, cursor, IndexQueryConstraints.unconstrained(), new TokenPredicate(this.labelTwo));
                IndexReadAsserts.assertNodeCount((NodeIndexCursor)cursor, 2, (MutableLongSet)uniqueIds);
                read.nodeLabelScan(session, cursor, IndexQueryConstraints.unconstrained(), new TokenPredicate(this.labelThree));
                IndexReadAsserts.assertNodeCount((NodeIndexCursor)cursor, 3, (MutableLongSet)uniqueIds);
                uniqueIds.clear();
                read.nodeLabelScan(session, cursor, IndexQueryConstraints.unconstrained(), new TokenPredicate(this.labelFirst));
                IndexReadAsserts.assertNodeCount((NodeIndexCursor)cursor, 3, (MutableLongSet)uniqueIds);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private TokenReadSession getTokenReadSession(KernelTransaction tx) throws IndexNotFoundKernelException {
        AnyTokenSchemaDescriptor descriptor = SchemaDescriptor.forAnyEntityTokens((EntityType)EntityType.NODE);
        Iterator indexes = tx.schemaRead().index((SchemaDescriptor)descriptor);
        TokenReadSession session = tx.dataRead().tokenReadSession((IndexDescriptor)indexes.next());
        return session;
    }

    @Test
    void shouldFindNodesByLabelInTx() throws Exception {
        long deletedInTx;
        long inStore;
        try (KernelTransaction tx = this.beginTransaction();){
            inStore = this.createNode(tx.dataWrite(), this.labelOne);
            this.createNode(tx.dataWrite(), this.labelTwo);
            deletedInTx = this.createNode(tx.dataWrite(), this.labelOne);
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            tx.dataWrite().nodeDelete(deletedInTx);
            long createdInTx = this.createNode(tx.dataWrite(), this.labelOne);
            this.createNode(tx.dataWrite(), this.labelTwo);
            Read read = tx.dataRead();
            TokenReadSession session = this.getTokenReadSession(tx);
            try (NodeLabelIndexCursor cursor = tx.cursors().allocateNodeLabelIndexCursor(tx.cursorContext());){
                LongHashSet uniqueIds = new LongHashSet();
                read.nodeLabelScan(session, cursor, IndexQueryConstraints.unconstrained(), new TokenPredicate(this.labelOne));
                IndexReadAsserts.assertNodes((NodeIndexCursor)cursor, (MutableLongSet)uniqueIds, inStore, createdInTx);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private long createNode(Write write, int ... labels) throws KernelException {
        long nodeId = write.nodeCreate();
        for (int label : labels) {
            write.nodeAddLabel(nodeId, label);
        }
        return nodeId;
    }
}

