/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.io.ByteUnit;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckpointAppender;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;

@DbmsExtension(configurationCallback="configure")
public class CheckpointLogFileRotationIT {
    @Inject
    private GraphDatabaseService database;
    @Inject
    private LogFiles logFiles;

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseInternalSettings.checkpoint_logical_log_rotation_threshold, (Object)ByteUnit.kibiBytes((long)1L)).setConfig(GraphDatabaseInternalSettings.checkpoint_logical_log_keep_threshold, (Object)100);
    }

    @Test
    void rotateCheckpointLogFiles() throws IOException {
        CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
        CheckpointAppender checkpointAppender = checkpointFile.getCheckpointAppender();
        LogPosition logPosition = new LogPosition(1000L, 12345L);
        String reason = "checkpoint for rotation test";
        for (int i = 0; i < 105; ++i) {
            checkpointAppender.checkPoint(LogCheckPointEvent.NULL, logPosition, Instant.now(), reason);
        }
        Object[] matchedFiles = checkpointFile.getDetachedCheckpointFiles();
        Assertions.assertThat((Object[])matchedFiles).hasSize(22);
        for (Object fileWithCheckpoints : matchedFiles) {
            Assertions.assertThat((Path)fileWithCheckpoints).satisfies((Condition)new Condition<Path>(){

                public boolean matches(Path file) {
                    long length = file.toFile().length();
                    return length == ByteUnit.kibiBytes((long)1L) || length == 64L;
                }
            });
        }
    }

    @Test
    void doNotRotateWhileCheckpointsAreFitting() throws IOException {
        CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
        CheckpointAppender checkpointAppender = checkpointFile.getCheckpointAppender();
        LogPosition logPosition = new LogPosition(1000L, 12345L);
        String reason = "checkpoint for rotation test";
        for (int i = 0; i < 4; ++i) {
            checkpointAppender.checkPoint(LogCheckPointEvent.NULL, logPosition, Instant.now(), reason);
        }
        Assertions.assertThat((Object[])checkpointFile.getDetachedCheckpointFiles()).hasSize(1);
    }

    @Test
    void afterRotationNewFileHaveHeader() throws IOException {
        CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
        CheckpointAppender checkpointAppender = checkpointFile.getCheckpointAppender();
        LogPosition logPosition = new LogPosition(1000L, 12345L);
        String reason = "checkpoint for rotation test";
        for (int i = 0; i < 5; ++i) {
            checkpointAppender.checkPoint(LogCheckPointEvent.NULL, logPosition, Instant.now(), reason);
        }
        Object[] matchedFiles = checkpointFile.getDetachedCheckpointFiles();
        Assertions.assertThat((Object[])matchedFiles).hasSize(2);
        boolean headerFileFound = false;
        for (Object matchedFile : matchedFiles) {
            if (checkpointFile.getDetachedCheckpointLogFileVersion((Path)matchedFile) != 1L) continue;
            Assertions.assertThat((File)matchedFile.toFile()).hasSize(64L);
            headerFileFound = true;
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)headerFileFound);
    }
}

