/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tracers;

import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomStringUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.scheduler.CentralJobScheduler;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;
import org.neo4j.time.Clocks;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@DbmsExtension(configurationCallback="configure")
class PropertyStoreTraceIT {
    @Inject
    private GraphDatabaseAPI database;
    @Inject
    private RecordStorageEngine storageEngine;

    PropertyStoreTraceIT() {
    }

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        Dependencies dependencies = new Dependencies();
        dependencies.satisfyDependency((Object)new CentralJobScheduler(Clocks.nanoClock()){

            public JobHandle<?> scheduleRecurring(Group group, JobMonitoringParams monitoredJobParams, Runnable runnable, long period, TimeUnit timeUnit) {
                return JobHandle.EMPTY;
            }

            public JobHandle<?> scheduleRecurring(Group group, JobMonitoringParams monitoredJobParams, Runnable runnable, long initialDelay, long period, TimeUnit unit) {
                return JobHandle.EMPTY;
            }
        });
        builder.setExternalDependencies((DependencyResolver)dependencies);
    }

    @Test
    void tracePageCacheAccessOnPropertyBlockIdGeneration() {
        PropertyStore propertyStore = this.storageEngine.testAccessNeoStores().getPropertyStore();
        this.prepareIdGenerator(propertyStore.getStringStore().getIdGenerator());
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
        try (CursorContext cursorContext = new CursorContext(pageCacheTracer.createPageCursorTracer("tracePageCacheAccessOnPropertyBlockIdGeneration"));){
            PropertyBlock propertyBlock = new PropertyBlock();
            DynamicRecord dynamicRecord = new DynamicRecord(2L);
            dynamicRecord.setData(new byte[]{0, 1, 2, 3, 4, 5, 6, 7});
            propertyBlock.addValueRecord(dynamicRecord);
            propertyStore.encodeValue(propertyBlock, 1, (Value)Values.stringValue((String)RandomStringUtils.randomAlphabetic((int)((int)ByteUnit.kibiBytes((long)4L)))), cursorContext, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            PageCursorTracer cursorTracer = cursorContext.getCursorTracer();
            Assertions.assertThat((long)cursorTracer.pins()).isOne();
            Assertions.assertThat((long)cursorTracer.unpins()).isOne();
            Assertions.assertThat((long)cursorTracer.hits()).isOne();
        }
    }

    private void prepareIdGenerator(IdGenerator idGenerator) {
        try (IdGenerator.Marker marker = idGenerator.marker(CursorContext.NULL);){
            marker.markFree(1L);
        }
        idGenerator.clearCache(CursorContext.NULL);
    }
}

