/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.concurrent.TimeUnit;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.IndexOrderTestBase;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class NodeIndexOrderTest
extends IndexOrderTestBase<NodeValueIndexCursor> {
    public static final String DEFAULT_LABEL = "Node";

    @Override
    protected Pair<Long, Value> entityWithProp(KernelTransaction tx, Object value) throws Exception {
        Write write = tx.dataWrite();
        long node = write.nodeCreate();
        write.nodeAddLabel(node, tx.tokenWrite().labelGetOrCreateForName(DEFAULT_LABEL));
        Value val = Values.of((Object)value);
        write.nodeSetProperty(node, tx.tokenWrite().propertyKeyGetOrCreateForName("prop"), val);
        return Pair.of((Object)node, (Object)val);
    }

    @Override
    protected void createIndex() {
        try (Transaction tx = graphDb.beginTx();){
            tx.schema().indexFor(Label.label((String)DEFAULT_LABEL)).on("prop").withName("myIndex").create();
            tx.commit();
        }
        tx = graphDb.beginTx();
        try {
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Override
    protected long entityReference(NodeValueIndexCursor cursor) {
        return cursor.nodeReference();
    }

    @Override
    protected NodeValueIndexCursor getEntityValueIndexCursor(KernelTransaction tx) {
        return tx.cursors().allocateNodeValueIndexCursor(tx.cursorContext(), tx.memoryTracker());
    }

    @Override
    protected void entityIndexSeek(KernelTransaction tx, IndexReadSession index, NodeValueIndexCursor cursor, IndexQueryConstraints constraints, PropertyIndexQuery query) throws KernelException {
        tx.dataRead().nodeIndexSeek(index, cursor, constraints, new PropertyIndexQuery[]{query});
    }

    @Override
    protected void entityIndexScan(KernelTransaction tx, IndexReadSession index, NodeValueIndexCursor cursor, IndexQueryConstraints constraints) throws KernelException {
        tx.dataRead().nodeIndexScan(index, cursor, constraints);
    }

    @Override
    protected void createCompositeIndex() {
        try (Transaction tx = graphDb.beginTx();){
            tx.schema().indexFor(Label.label((String)DEFAULT_LABEL)).on("prop1").on("prop2").withName("myIndex").create();
            tx.commit();
        }
        tx = graphDb.beginTx();
        try {
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Override
    protected Pair<Long, Value[]> entityWithTwoProps(KernelTransaction tx, Object value1, Object value2) throws Exception {
        Write write = tx.dataWrite();
        long node = write.nodeCreate();
        TokenWrite tokenWrite = tx.tokenWrite();
        write.nodeAddLabel(node, tokenWrite.labelGetOrCreateForName(DEFAULT_LABEL));
        Value val1 = Values.of((Object)value1);
        Value val2 = Values.of((Object)value2);
        write.nodeSetProperty(node, tokenWrite.propertyKeyGetOrCreateForName("prop1"), val1);
        write.nodeSetProperty(node, tokenWrite.propertyKeyGetOrCreateForName("prop2"), val2);
        return Pair.of((Object)node, (Object)new Value[]{val1, val2});
    }
}

