/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.coreapi.TransactionImpl;
import org.neo4j.test.Barrier;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;

@ExtendWith(value={RandomExtension.class})
@ImpermanentDbmsExtension
class DeleteNodeWithRelationshipsIT {
    @Inject
    private GraphDatabaseService db;

    DeleteNodeWithRelationshipsIT() {
    }

    @Test
    void shouldGiveHelpfulExceptionWhenDeletingNodeWithRelationships() {
        Node node;
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode();
            node.createRelationshipTo(tx.createNode(), RelationshipType.withName((String)"MAYOR_OF"));
            tx.commit();
        }
        tx = this.db.beginTx();
        tx.getNodeById(node.getId()).delete();
        ConstraintViolationException ex = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> ((Transaction)tx).commit());
        org.junit.jupiter.api.Assertions.assertEquals((Object)("Cannot delete node<" + node.getId() + ">, because it still has relationships. To delete this node, you must first delete its relationships."), (Object)ex.getMessage());
    }

    @Test
    void shouldDeleteDenseNodeEvenWithTemporarilyCreatedRelationshipsBeforeDeletion() {
        long nodeId;
        Node node;
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode();
            nodeId = node.getId();
            for (int i = 0; i < 200; ++i) {
                node.createRelationshipTo(tx.createNode(), RelationshipType.withName((String)("TYPE_" + i % 3)));
            }
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            node = tx.getNodeById(nodeId);
            node.createRelationshipTo(tx.createNode(), RelationshipType.withName((String)"OTHER_TYPE_1"));
            node.createRelationshipTo(tx.createNode(), RelationshipType.withName((String)"OTHER_TYPE_2"));
            node.getRelationships().forEach(Relationship::delete);
            node.delete();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            org.junit.jupiter.api.Assertions.assertThrows(NotFoundException.class, () -> tx.getNodeById(nodeId));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldDeleteDenseNodeIfContainingEmptyGroupsFromPreviousContendedRelationshipDeletions() throws ExecutionException, InterruptedException {
        long nodeId;
        RelationshipType typeA = RelationshipType.withName((String)"A");
        RelationshipType typeB = RelationshipType.withName((String)"B");
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            nodeId = node.getId();
            for (int i = 0; i < 200; ++i) {
                node.createRelationshipTo(tx.createNode(), i % 2 == 0 ? typeA : typeB);
            }
            tx.commit();
        }
        try (OtherThreadExecutor t2 = new OtherThreadExecutor("T2");){
            Barrier.Control barrier = new Barrier.Control();
            Future t2Future = t2.executeDontWait(() -> {
                try (TransactionImpl tx = (TransactionImpl)this.db.beginTx();){
                    tx.getNodeById(nodeId).createRelationshipTo(tx.createNode(), typeB);
                    tx.commit(() -> ((Barrier.Control)barrier).reached());
                }
                return null;
            });
            barrier.awaitUninterruptibly();
            try (Transaction tx = this.db.beginTx();){
                tx.getNodeById(nodeId).getRelationships(new RelationshipType[]{typeA}).forEach(Relationship::delete);
                tx.commit();
            }
            barrier.release();
            t2Future.get();
        }
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.getNodeById(nodeId);
            node.getRelationships().forEach(relationship -> {
                Assertions.assertThat((boolean)relationship.isType(typeB)).isTrue();
                relationship.delete();
            });
            node.delete();
            tx.commit();
        }
    }

    @Test
    void shouldDeleteDenseNodeIfContainingEmptyGroups() throws Exception {
        long nodeId;
        RelationshipType typeA = RelationshipType.withName((String)"A");
        RelationshipType typeB = RelationshipType.withName((String)"B");
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            nodeId = node.getId();
            node.createRelationshipTo(tx.createNode(), typeA);
            for (int i = 0; i < 200; ++i) {
                node.createRelationshipTo(tx.createNode(), typeA);
            }
            tx.getNodeById(nodeId).createRelationshipTo(tx.createNode(), typeB);
            tx.commit();
        }
        try (OtherThreadExecutor t2 = new OtherThreadExecutor("T2");){
            Barrier.Control barrier = new Barrier.Control();
            Future t2Future = t2.executeDontWait(() -> {
                try (TransactionImpl tx = (TransactionImpl)this.db.beginTx();){
                    tx.getNodeById(nodeId).createRelationshipTo(tx.createNode(), typeA);
                    tx.commit(() -> ((Barrier.Control)barrier).reached());
                }
                return null;
            });
            barrier.awaitUninterruptibly();
            try (Transaction tx = this.db.beginTx();){
                tx.getNodeById(nodeId).getRelationships(new RelationshipType[]{typeB}).forEach(Relationship::delete);
                tx.commit();
            }
            barrier.release();
            t2Future.get();
            tx = this.db.beginTx();
            try {
                tx.getNodeById(nodeId).getRelationships(new RelationshipType[]{typeA}).forEach(Relationship::delete);
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        try (Transaction tx = this.db.beginTx();){
            tx.getNodeById(nodeId).delete();
            Assertions.assertThatCode(() -> ((Transaction)tx).commit()).doesNotThrowAnyException();
        }
    }
}

